/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.BundleContextRegistrar;
import com.github.dynamicextensionsalfresco.osgi.BundleDependencies;
import com.github.dynamicextensionsalfresco.osgi.Configuration;
import com.github.dynamicextensionsalfresco.osgi.FrameworkManager;
import com.github.dynamicextensionsalfresco.osgi.RepositoryStoreService;
import com.github.dynamicextensionsalfresco.osgi.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class DefaultFrameworkManager
implements ResourceLoaderAware,
FrameworkManager {
    private final Logger logger = LoggerFactory.getLogger(DefaultFrameworkManager.class);
    private final Framework framework;
    private final List<BundleContextRegistrar> bundleContextRegistrars;
    private final RepositoryStoreService repositoryStoreService;
    private final ContentService contentService;
    private final Configuration configuration;
    private final String blueprintBundlesLocation;
    private final String standardBundlesLocation;
    private final String customBundlesLocation;
    private ResourcePatternResolver resourcePatternResolver;
    private ArrayList<ServiceRegistration<?>> serviceRegistrations = new ArrayList();

    public DefaultFrameworkManager(Framework framework, List<BundleContextRegistrar> bundleContextRegistrars, RepositoryStoreService repositoryStoreService, ContentService contentService, Configuration configuration, String blueprintBundlesLocation, String standardBundlesLocation, String customBundlesLocation) {
        this.framework = framework;
        this.bundleContextRegistrars = bundleContextRegistrars;
        this.repositoryStoreService = repositoryStoreService;
        this.contentService = contentService;
        this.configuration = configuration;
        this.blueprintBundlesLocation = blueprintBundlesLocation;
        this.standardBundlesLocation = standardBundlesLocation;
        this.customBundlesLocation = customBundlesLocation;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.isInstanceOf(ResourcePatternResolver.class, (Object)resourceLoader);
        this.resourcePatternResolver = (ResourcePatternResolver)resourceLoader;
    }

    public final void initialize() {
        this.startFramework();
        this.registerServices();
        this.startBundles(this.installCoreBundles());
        if (this.getRepositoryInstallEnabled()) {
            this.startBundles(this.installRepositoryBundles());
        }
    }

    private boolean getRepositoryInstallEnabled() {
        return this.configuration.getRepositoryBundlesEnabled();
    }

    protected void startFramework() {
        try {
            this.logger.debug("Starting Framework");
            this.framework.start();
        }
        catch (BundleException e) {
            this.logger.error("Could not start Framework.", (Throwable)e);
        }
    }

    protected void registerServices() {
        this.logger.debug("Registering services.");
        for (BundleContextRegistrar bundleContextRegistrar : this.bundleContextRegistrars) {
            List<ServiceRegistration<?>> servicesRegistered = bundleContextRegistrar.registerInBundleContext(this.framework.getBundleContext());
            this.serviceRegistrations.addAll(servicesRegistered);
        }
    }

    protected List<Bundle> installCoreBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try {
            ArrayList<String> locationPatterns = new ArrayList<String>();
            locationPatterns.add(this.blueprintBundlesLocation);
            if (StringUtils.hasText((String)this.standardBundlesLocation)) {
                locationPatterns.add(this.standardBundlesLocation);
            }
            if (StringUtils.hasText((String)this.customBundlesLocation)) {
                locationPatterns.add(this.customBundlesLocation);
            }
            for (String locationPattern : locationPatterns) {
                try {
                    for (Resource bundleResource : this.resourcePatternResolver.getResources(locationPattern)) {
                        String location = bundleResource.getURI().toString();
                        this.logger.debug("Installing Bundle: {}", (Object)location);
                        try {
                            Bundle bundle = this.installBundle(bundleResource, location);
                            bundles.add(bundle);
                        }
                        catch (BundleException e) {
                            this.logger.error("Error installing Bundle in {}: {}", (Object)location, (Object)e);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.debug("Could not find Bundles at location '{}'.", (Object)locationPattern);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error installing core Bundles: " + ioe.getMessage(), ioe);
        }
        return bundles;
    }

    private Bundle installBundle(Resource bundleResource, String location) throws IOException, BundleException {
        Bundle bundle = this.framework.getBundleContext().installBundle(location, bundleResource.getInputStream());
        if (bundle.getSymbolicName() == null) {
            bundle.uninstall();
            File localCopy = FileUtil.toTempFile(bundleResource.getInputStream(), "wrapped", ".jar");
            File bundleFile = FileUtil.convertToBundle(localCopy, bundleResource.getFilename());
            bundle = this.framework.getBundleContext().installBundle(location, (InputStream)new FileInputStream(bundleFile));
            this.logger.info("Wrapped plain jar as a OSGi bundle: " + bundle.getSymbolicName());
        }
        return bundle;
    }

    protected void startBundles(List<Bundle> bundles) {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.framework.adapt(FrameworkWiring.class);
        if (!frameworkWiring.resolveBundles(bundles)) {
            this.logger.warn("Could not resolve all {} bundles.", (Object)bundles.size());
        }
        List<Bundle> sortedByDependency = BundleDependencies.sortByDependencies(bundles);
        for (Bundle bundle : sortedByDependency) {
            if ((bundle.getState() & 4) != 4) {
                this.logger.error("Bundle {} failed to resolve. State: {}", (Object)bundle.getSymbolicName(), (Object)bundle.getState());
            }
            if (this.isFragmentBundle(bundle)) continue;
            this.startBundle(bundle);
        }
    }

    protected void startBundle(Bundle bundle) {
        try {
            this.logger.debug("Starting Bundle {}.", (Object)bundle.getSymbolicName());
            bundle.start();
        }
        catch (Exception e) {
            this.logger.error("Error starting bundle {}:", (Object)bundle.getSymbolicName(), (Object)e);
        }
    }

    protected boolean isFragmentBundle(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    protected List<Bundle> installRepositoryBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (FileInfo jarFile : this.repositoryStoreService.getBundleJarFiles()) {
            try {
                String location = String.format("%s/%s", this.repositoryStoreService.getBundleRepositoryLocation(), jarFile.getName());
                this.logger.debug("Installing Bundle: {}", (Object)location);
                ContentReader reader = this.contentService.getReader(jarFile.getNodeRef(), ContentModel.PROP_CONTENT);
                if (reader != null) {
                    Bundle bundle = this.framework.getBundleContext().installBundle(location, reader.getContentInputStream());
                    bundles.add(bundle);
                    continue;
                }
                this.logger.warn("unable to read extension content for {}", (Object)jarFile.getNodeRef());
            }
            catch (Exception e) {
                this.logger.warn("Error installing Bundle: {}", (Object)jarFile.getNodeRef());
            }
        }
        return bundles;
    }

    protected void destroy() {
        this.unregisterServices();
        this.stopFramework();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterServices() {
        Iterator<ServiceRegistration<?>> it = this.serviceRegistrations.iterator();
        while (it.hasNext()) {
            ServiceRegistration<?> serviceRegistration = it.next();
            try {
                this.logger.debug("Unregistering service {}", (Object)serviceRegistration.getReference());
                serviceRegistration.unregister();
            }
            catch (RuntimeException e) {
                this.logger.warn("Error unregistering service $serviceRegistration.", (Throwable)e);
            }
            finally {
                it.remove();
            }
        }
    }

    protected void stopFramework() {
        try {
            this.logger.debug("Stopping Framework.");
            this.framework.stop();
            this.framework.waitForStop(0L);
        }
        catch (BundleException e) {
            this.logger.error("Could not stop Framework.", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

