/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.DependencyMetadataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencySorter {
    public static Logger logger = LoggerFactory.getLogger(DependencySorter.class);

    public static <T> Collection<T> sort(Collection<T> input, DependencyMetadataProvider<T> metadataProvider) {
        ArrayList result = new ArrayList();
        Map<Object, T> exports = DependencySorter.collectExports(input, metadataProvider);
        ArrayList visitedItems = new ArrayList();
        for (T item : input) {
            DependencySorter.visit(item, exports, result, visitedItems, metadataProvider);
        }
        DependencySorter.LogDebug(input, result);
        return result;
    }

    private static <T> void LogDebug(Collection<T> input, ArrayList<T> result) {
        if (logger.isDebugEnabled()) {
            Iterator<T> it;
            Iterator<T> iterator = it = input == null ? null : input.iterator();
            if (it == null || !it.hasNext()) {
                logger.debug("sorting empty or 'null' collection");
                return;
            }
            logger.debug("sorting {}:", it.next());
            logger.debug("  input");
            for (T item : input) {
                logger.debug("  - {}", item);
            }
            logger.debug("  output");
            for (T item : result) {
                logger.debug("  - {}", item);
            }
        }
    }

    private static <T> void visit(T item, Map<Object, T> exports, ArrayList<T> output, ArrayList<T> visited, DependencyMetadataProvider<T> metadataProvider) {
        visited.add(item);
        Collection<Object> imports = metadataProvider.imports(item);
        for (Object importz : imports) {
            T exportingItem = exports.get(importz);
            if (exportingItem == null || exportingItem == item || output.contains(exportingItem)) continue;
            logger.debug("visit {} from {} for import {}", new Object[]{exportingItem, item, importz});
            if (!visited.contains(exportingItem)) {
                DependencySorter.visit(exportingItem, exports, output, visited, metadataProvider);
                continue;
            }
            if (metadataProvider.allowCircularReferences()) continue;
            String message = String.format("Circular dependency detected between %s and %s for import %s", item, exportingItem, importz);
            throw new IllegalArgumentException(message);
        }
        if (!output.contains(item)) {
            output.add(item);
        }
    }

    private static <T> Map<Object, T> collectExports(Collection<T> items, DependencyMetadataProvider<T> metadataProvider) {
        HashMap<Object, T> result = new HashMap<Object, T>();
        for (T item : items) {
            Collection<Object> exports = metadataProvider.exports(item);
            for (Object export : exports) {
                result.put(export, item);
            }
        }
        return result;
    }
}

