/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.Configuration;
import com.github.dynamicextensionsalfresco.osgi.ConfigurationValues;
import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.util.Assert;

public class FrameworkConfiguration {
    private Configuration configuration;
    private boolean flushBundleCacheOnFirstInit = true;
    private ConfigurationValues<SystemPackage> coreSystemPackages = null;
    private ConfigurationValues<SystemPackage> additionalSystemPackages = null;

    public Map<String, String> toMap() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        if (this.getStorageDirectory() != null) {
            configuration.put("org.osgi.framework.storage", this.getStorageDirectory().getAbsolutePath());
        }
        if (this.isFlushBundleCacheOnFirstInit()) {
            configuration.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        if (this.getCoreSystemPackages() != null) {
            configuration.put("org.osgi.framework.system.packages", this.createSystemPackagesConfiguration(this.getCoreSystemPackages()));
        }
        if (this.getAdditionalSystemPackages() != null) {
            configuration.put("org.osgi.framework.system.packages.extra", this.createSystemPackagesConfiguration(this.getAdditionalSystemPackages()));
        }
        if (this.getBootDelegation() != null) {
            configuration.put("org.osgi.framework.bootdelegation", this.getBootDelegation());
        }
        return configuration;
    }

    protected String createSystemPackagesConfiguration(ConfigurationValues<SystemPackage> systemPackages) {
        StringBuilder sb = new StringBuilder();
        Iterator<SystemPackage> it = systemPackages.iterator();
        while (it.hasNext()) {
            SystemPackage systemPackage = it.next();
            String version = systemPackage.getVersion();
            if (version == null) {
                version = "1.0";
            }
            sb.append(systemPackage.getName()).append(";version=").append(version);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void setConfiguration(Configuration configuration) {
        Assert.notNull((Object)configuration);
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File getStorageDirectory() {
        return this.getConfiguration().getStorageDirectory();
    }

    public String getBootDelegation() {
        return this.getConfiguration().getBootDelegation();
    }

    public boolean isFlushBundleCacheOnFirstInit() {
        return this.flushBundleCacheOnFirstInit;
    }

    public void setFlushBundleCacheOnFirstInit(boolean flushBundleCacheOnFirstInit) {
        this.flushBundleCacheOnFirstInit = flushBundleCacheOnFirstInit;
    }

    public void setCoreSystemPackages(ConfigurationValues<SystemPackage> coreSystemPackages) {
        Assert.notNull(coreSystemPackages);
        this.coreSystemPackages = coreSystemPackages;
    }

    public ConfigurationValues<SystemPackage> getCoreSystemPackages() {
        return this.coreSystemPackages;
    }

    public void setAdditionalSystemPackages(ConfigurationValues<SystemPackage> additionalSystemPackages) {
        Assert.notNull(additionalSystemPackages);
        this.additionalSystemPackages = additionalSystemPackages;
    }

    public ConfigurationValues<SystemPackage> getAdditionalSystemPackages() {
        return this.additionalSystemPackages;
    }
}

