/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.FrameworkService;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class FrameworkRestartWebScript
extends AbstractWebScript {
    private FrameworkService frameworkService;
    private Container webScriptsContainer;

    public void execute(WebScriptRequest request, WebScriptResponse response) throws IOException {
        this.frameworkService.restartFramework();
        this.webScriptsContainer.reset();
        this.sendJsonResponse(response);
    }

    private void sendJsonResponse(WebScriptResponse response) throws IOException {
        try {
            JSONObject result = new JSONObject();
            result.put("status", 200);
            result.put("message", (Object)"Restarted OSGi framework.");
            response.setContentType("application/json");
            response.getWriter().write(result.toString(2) + "\n");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFrameworkService(FrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    public void setWebScriptsContainer(Container webScriptsContainer) {
        this.webScriptsContainer = webScriptsContainer;
    }
}

