/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.ManifestUtils;
import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import com.springsource.util.osgi.manifest.ExportedPackage;
import com.springsource.util.osgi.manifest.internal.StandardBundleManifest;
import com.springsource.util.osgi.manifest.parse.BundleManifestParseException;
import com.springsource.util.osgi.manifest.parse.DummyParserLogger;
import com.springsource.util.osgi.manifest.parse.ParserLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.alfresco.service.descriptor.DescriptorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class JavaPackageScanner
implements ServletContextAware {
    private static final String OSGI_PACKAGE = "org.osgi";
    private static final String FELIX_PACKAGE = "org.apache.felix";
    private static final Collection<String> frameworkPackages = Arrays.asList("org.osgi", "org.apache.felix");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServletContextResourcePatternResolver resourcePatternResolver;
    private ServletContext servletContext;
    private DescriptorService descriptorService;

    public Set<SystemPackage> scanWebApplicationPackages() {
        LinkedHashSet<SystemPackage> systemPackages;
        block7: {
            if (this.resourcePatternResolver == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("ResourcePatternResolver was not configured. This is normal during a unit test.");
                }
                return Collections.emptySet();
            }
            this.logger.debug("Scanning for Java packages.");
            long before = System.currentTimeMillis();
            systemPackages = new LinkedHashSet<SystemPackage>(4500, 0.1f);
            try {
                for (Resource jarResource : this.resourcePatternResolver.getResources("/WEB-INF/lib/*.jar")) {
                    String jarPath = this.servletContext.getRealPath(String.format("/WEB-INF/lib/%s", jarResource.getFilename()));
                    JarFile jarFile = new JarFile(jarPath);
                    Set<SystemPackage> exportPackages = this.scanBundleExportPackages(jarFile);
                    if (exportPackages != null) {
                        systemPackages.addAll(exportPackages);
                        continue;
                    }
                    Set<SystemPackage> javaPackages = this.scanJavaPackages(jarFile);
                    systemPackages.addAll(javaPackages);
                }
                long after = System.currentTimeMillis();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Found {} Java packages. Time taken: {}ms.", (Object)systemPackages.size(), (Object)(after - before));
                }
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn("Error scanning Java packages. This will cause Dynamic Extensions framework not to work!", (Throwable)e);
            }
        }
        return systemPackages;
    }

    protected boolean isFrameworkPackage(String packageName) {
        for (String frameworkPackage : frameworkPackages) {
            if (!packageName.startsWith(frameworkPackage)) continue;
            return true;
        }
        return false;
    }

    protected Set<SystemPackage> scanBundleExportPackages(JarFile jarFile) throws IOException {
        LinkedHashSet<SystemPackage> exportPackages;
        block5: {
            exportPackages = null;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                Map<String, String> contents = this.convertAttributesToMap(manifest.getMainAttributes());
                try {
                    StandardBundleManifest bundleManifest = new StandardBundleManifest((ParserLogger)new DummyParserLogger(), contents);
                    if (bundleManifest.getBundleName() != null) {
                        List exportedPackages = bundleManifest.getExportPackage().getExportedPackages();
                        exportPackages = new LinkedHashSet<SystemPackage>(exportedPackages.size());
                        for (ExportedPackage exportedPackage : exportedPackages) {
                            SystemPackage exportPackage = new SystemPackage(exportedPackage.getPackageName(), exportedPackage.getVersion().toString());
                            exportPackages.add(exportPackage);
                        }
                    }
                }
                catch (BundleManifestParseException e) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug(String.format("Failed to parse manifest for %s, reverting to content scanning.", jarFile.getName()), (Throwable)e);
                }
            }
        }
        return exportPackages;
    }

    protected Map<String, String> convertAttributesToMap(Attributes attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = entry.getKey().toString();
            map.put(key, entry.getValue() != null ? entry.getValue().toString() : null);
        }
        return map;
    }

    protected Set<SystemPackage> scanJavaPackages(JarFile jarFile) throws IOException {
        String implementationVersion = ManifestUtils.getImplementationVersion(jarFile);
        LinkedHashSet<SystemPackage> systemPackages = new LinkedHashSet<SystemPackage>(30);
        HashSet<String> foundPackages = new HashSet<String>(30, 0.1f);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String name;
            String packageName;
            JarEntry jarEntry = entries.nextElement();
            if (!this.isJavaClassInPackage(jarEntry) || this.isFrameworkPackage(packageName = (name = jarEntry.getName()).substring(0, name.lastIndexOf(47)).replace('/', '.')) || foundPackages.contains(packageName)) continue;
            if (this.isAlfrescoPackage(packageName)) {
                String alfrescoVersion = this.descriptorService.getServerDescriptor().getVersionNumber().toString();
                systemPackages.add(new SystemPackage(packageName, alfrescoVersion));
            } else {
                systemPackages.add(new SystemPackage(packageName, implementationVersion));
            }
            foundPackages.add(packageName);
        }
        return systemPackages;
    }

    protected boolean isJavaClassInPackage(JarEntry jarEntry) {
        String name = jarEntry.getName();
        return name.lastIndexOf(47) > -1 && name.endsWith(".class");
    }

    protected boolean isAlfrescoPackage(String packageName) {
        return packageName.startsWith("org.alfresco");
    }

    public boolean isCacheValid(File systemPackageCache) {
        if (!systemPackageCache.isFile()) {
            return false;
        }
        Resource libDir = this.resourcePatternResolver.getResource("/WEB-INF/lib");
        try {
            boolean stale;
            boolean bl = stale = libDir.lastModified() > systemPackageCache.lastModified();
            if (stale) {
                this.logger.info("system package cache is older then WEB-INF/lib, rescan packages");
            }
            return !stale;
        }
        catch (IOException e) {
            this.logger.warn("unable to read WEB-INF/lib directory, keeping package cache");
            return true;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.resourcePatternResolver = new ServletContextResourcePatternResolver(servletContext);
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        Assert.notNull((Object)descriptorService);
        this.descriptorService = descriptorService;
    }
}

