/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtils {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtils.class);

    public static String getImplementationTitle(JarFile jarFile) throws IOException {
        List<Attributes> attributesList = ManifestUtils.getAllJarAttributes(jarFile);
        for (Attributes attributes : attributesList) {
            String title = (String)attributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
            if (title == null) continue;
            return title;
        }
        return null;
    }

    public static String getImplementationVersion(JarFile jarFile) throws IOException {
        List<Attributes> attributesList = ManifestUtils.getAllJarAttributes(jarFile);
        for (Attributes attributes : attributesList) {
            String version = (String)attributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
            if (version == null) continue;
            try {
                version = ManifestUtils.parseImplementationVersionValue(version).toString();
                Version.parseVersion((String)version);
                return version;
            }
            catch (IllegalArgumentException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Found invalid version '{}' in Implementation-Version header in JAR '{}'.", (Object)version, (Object)jarFile.getName());
            }
        }
        return null;
    }

    public static Version parseImplementationVersionValue(String rawVersion) {
        StringTokenizer st = new StringTokenizer(rawVersion, ".", false);
        int[] versions = new int[3];
        String qualifier = null;
        Pattern qualifierPattern = Pattern.compile("^(\\d+)(_|-)(.+)$");
        for (int x = 0; x < versions.length; ++x) {
            if (!st.hasMoreTokens()) continue;
            String token = st.nextToken();
            Matcher matcher = qualifierPattern.matcher(token);
            if (matcher.matches()) {
                versions[x] = Integer.parseInt(matcher.group(1));
                qualifier = matcher.group(3);
                break;
            }
            try {
                versions[x] = Integer.parseInt(token);
                continue;
            }
            catch (NumberFormatException e) {
                qualifier = token;
                break;
            }
        }
        return new Version(versions[0], versions[1], versions[2], qualifier);
    }

    public static List<Attributes> getAllJarAttributes(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return Collections.emptyList();
        }
        ArrayList<Attributes> attributesList = new ArrayList<Attributes>(manifest.getEntries().size() + 1);
        attributesList.add(manifest.getMainAttributes());
        attributesList.addAll(manifest.getEntries().values());
        return attributesList;
    }
}

