/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.FrameworkManager;
import com.github.dynamicextensionsalfresco.osgi.FrameworkService;
import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class OsgiContainerModuleComponent
extends AbstractModuleComponent
implements ApplicationContextAware,
FrameworkService {
    private ConfigurableWebApplicationContext applicationContext;
    private String[] applicationContextConfigLocations;
    private ConfigurableWebApplicationContext childApplicationContext;
    private TransactionService transactionService;

    protected void executeInternal() {
        this.startFramework();
    }

    public void destroy() {
        this.stopFramework();
    }

    @Override
    public void restartFramework() {
        RetryingTransactionHelper transactionHelper = this.getTransactionService().getRetryingTransactionHelper();
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return (Void)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        try {
                            OsgiContainerModuleComponent.this.stopFramework();
                        }
                        finally {
                            OsgiContainerModuleComponent.this.startFramework();
                        }
                        return null;
                    }
                }, (String)"System");
            }
        });
    }

    protected void startFramework() {
        if (this.childApplicationContext == null) {
            try {
                this.initializeOsgiContainerApplicationContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initializeOsgiContainerApplicationContext() {
        this.childApplicationContext = new EventHandlingXmlWebApplicationContext();
        this.childApplicationContext.setParent((ApplicationContext)this.getApplicationContext());
        this.childApplicationContext.setServletContext(this.getApplicationContext().getServletContext());
        this.childApplicationContext.setConfigLocation(StringUtils.arrayToDelimitedString((Object[])this.getApplicationContextConfigLocations(), (String)","));
        this.childApplicationContext.refresh();
    }

    protected void stopFramework() {
        if (this.childApplicationContext != null) {
            try {
                this.childApplicationContext.close();
            }
            finally {
                this.childApplicationContext = null;
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = (ConfigurableWebApplicationContext)applicationContext;
    }

    protected ConfigurableWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setApplicationContextConfigLocations(String[] applicationContextConfigLocations) {
        this.applicationContextConfigLocations = applicationContextConfigLocations;
    }

    protected String[] getApplicationContextConfigLocations() {
        return this.applicationContextConfigLocations;
    }

    @Override
    public FrameworkManager getFrameworkManager() {
        Assert.state((this.childApplicationContext != null ? 1 : 0) != 0);
        return (FrameworkManager)this.childApplicationContext.getBean("osgi.container.FrameworkManager", FrameworkManager.class);
    }

    private static class EventHandlingXmlWebApplicationContext
    extends XmlWebApplicationContext {
        private EventHandlingXmlWebApplicationContext() {
        }

        public void publishEvent(ApplicationEvent event) {
            Assert.notNull((Object)event, (String)"Event must not be null");
            ((ApplicationEventMulticaster)this.getBean("applicationEventMulticaster")).multicastEvent(event);
            if (event instanceof ContextRefreshedEvent || event instanceof ContextClosedEvent) {
                return;
            }
            super.publishEvent(event);
        }
    }
}

