/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RepositoryStoreService {
    private static final String DEFAULT_BUNDLE_REPOSITORY_LOCATION = "/Company Home/Data Dictionary/Dynamic Extensions/Bundles";
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private String baseFolderDescription;
    private String bundleFolderDescription;
    private String configurationFolderDescription;
    private String bundleRepositoryLocation = "/Company Home/Data Dictionary/Dynamic Extensions/Bundles";

    public NodeRef getBaseFolder(boolean createIfNotExists) {
        QName name = this.qName("cm", "dynamic_extensions");
        NodeRef dataDictionary = this.getDataDictionary();
        NodeRef nodeRef = this.getChildOf(dataDictionary, name);
        if (nodeRef == null && createIfNotExists) {
            nodeRef = this.createFolder(dataDictionary, name, "Dynamic Extensions", this.getBaseFolderDescription());
            this.permissionService.setInheritParentPermissions(nodeRef, false);
        }
        return nodeRef;
    }

    public NodeRef getBundleFolder(boolean createIfNotExists) {
        QName name = this.qName("cm", "bundles");
        NodeRef baseFolder = this.getBaseFolder(createIfNotExists);
        NodeRef nodeRef = this.getChildOf(baseFolder, name);
        if (nodeRef == null && createIfNotExists) {
            nodeRef = this.createFolder(baseFolder, name, "Bundles", this.getBundleFolderDescription());
        }
        return nodeRef;
    }

    public NodeRef getConfigurationFolder(boolean createIfNotExists) {
        QName name = this.qName("cm", "configuration");
        NodeRef baseFolder = this.getBaseFolder(createIfNotExists);
        NodeRef nodeRef = this.getChildOf(baseFolder, name);
        if (nodeRef == null && createIfNotExists) {
            nodeRef = this.createFolder(baseFolder, name, "Configuration", this.getConfigurationFolderDescription());
        }
        return nodeRef;
    }

    public List<FileInfo> getBundleJarFiles() {
        ArrayList<FileInfo> jarFiles = new ArrayList<FileInfo>();
        NodeRef bundleFolder = this.getBundleFolder(false);
        if (bundleFolder != null) {
            for (FileInfo file : this.getFileFolderService().listFiles(bundleFolder)) {
                if (!file.getName().endsWith(".jar")) continue;
                jarFiles.add(file);
            }
        }
        return jarFiles;
    }

    protected NodeRef getDataDictionary() {
        return this.getChildOf(this.getCompanyHome(), this.qName("app", "dictionary"));
    }

    protected NodeRef getCompanyHome() {
        return this.getChildOfRootNode(this.qName("app", "company_home"));
    }

    protected NodeRef createFolder(final NodeRef parentFolder, final QName qName, final String name, final String description) {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                ChildAssociationRef childAssoc = RepositoryStoreService.this.nodeService.createNode(parentFolder, ContentModel.ASSOC_CONTAINS, qName, ContentModel.TYPE_FOLDER);
                if (childAssoc != null) {
                    NodeRef nodeRef = childAssoc.getChildRef();
                    RepositoryStoreService.this.getNodeService().setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)name));
                    if (StringUtils.hasText((String)description)) {
                        RepositoryStoreService.this.getNodeService().setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description.trim()));
                    }
                    return nodeRef;
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected NodeRef getChildOf(NodeRef nodeRef, QName assocType, QName assocName) {
        if (nodeRef == null) {
            return null;
        }
        List childAssocs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)assocType, (QNamePattern)assocName);
        if (!childAssocs.isEmpty()) {
            return ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
        }
        return null;
    }

    protected NodeRef getChildOf(NodeRef nodeRef, QName qName) {
        return this.getChildOf(nodeRef, ContentModel.ASSOC_CONTAINS, qName);
    }

    protected NodeRef getChildOfRootNode(QName qName) {
        return this.getChildOf(this.getNodeService().getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), ContentModel.ASSOC_CHILDREN, qName);
    }

    protected QName qName(String prefix, String localName) {
        return QName.createQName((String)prefix, (String)localName, (NamespacePrefixResolver)this.getNamespacePrefixResolver());
    }

    public void setNodeService(NodeService nodeService) {
        Assert.notNull((Object)nodeService);
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        Assert.notNull((Object)namespacePrefixResolver);
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    protected NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        Assert.notNull((Object)fileFolderService);
        this.fileFolderService = fileFolderService;
    }

    protected FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    protected String getBaseFolderDescription() {
        return this.baseFolderDescription;
    }

    public void setBaseFolderDescription(String baseFolderDescription) {
        this.baseFolderDescription = baseFolderDescription;
    }

    protected String getBundleFolderDescription() {
        return this.bundleFolderDescription;
    }

    public void setBundleFolderDescription(String bundleFolderDescription) {
        this.bundleFolderDescription = bundleFolderDescription;
    }

    protected String getConfigurationFolderDescription() {
        return this.configurationFolderDescription;
    }

    public void setConfigurationFolderDescription(String configurationFolderDescription) {
        this.configurationFolderDescription = configurationFolderDescription;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setBundleRepositoryLocation(String bundleRepositoryLocation) {
        Assert.hasText((String)bundleRepositoryLocation);
        this.bundleRepositoryLocation = bundleRepositoryLocation;
    }

    public String getBundleRepositoryLocation() {
        return this.bundleRepositoryLocation;
    }
}

