/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.BundleContextRegistrar;
import com.github.dynamicextensionsalfresco.osgi.ServiceDefinition;
import com.github.dynamicextensionsalfresco.osgi.ServicePropertiesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.VersionNumber;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ServiceBundleContextRegistrar
implements BundleContextRegistrar,
ApplicationContextAware {
    private static final String ALFRESCO_SERVICE_TYPE = "alfresco.service.type";
    private static final String OSGI_SERVICE_BLUEPRINT_COMPNAME = "osgi.service.blueprint.compname";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private DescriptorService descriptorService;
    private List<ServiceDefinition> serviceDefinitions = Collections.emptyList();
    private List<ServicePropertiesProvider> servicePropertiesProviders = Collections.emptyList();
    private final List<ServiceRegistration<?>> serviceRegistrations = new ArrayList();

    @Override
    public List<ServiceRegistration<?>> registerInBundleContext(BundleContext bundleContext) {
        Assert.notNull((Object)bundleContext, (String)"BundleContext cannot be null.");
        Descriptor descriptor = this.getDescriptorService().getServerDescriptor();
        if (descriptor == null && this.logger.isDebugEnabled()) {
            this.logger.debug("Could not obtain Descriptor. This is normal when running an integration test.");
        }
        for (ServiceDefinition serviceDefinition : this.getServiceDefinitions()) {
            int serviceRanking = 0;
            for (String beanName : serviceDefinition.getBeanNames()) {
                List<String> serviceNames = serviceDefinition.getServiceNames();
                String requiredPlatformVersion = serviceDefinition.getPlatformVersion();
                if (StringUtils.hasText((String)requiredPlatformVersion)) {
                    VersionNumber versionNumber = new VersionNumber(requiredPlatformVersion);
                    if (descriptor != null && versionNumber.compareTo(descriptor.getVersionNumber()) > 0) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Skipping registration of ServiceDefinitions {} because they require Alfresco version {}", serviceNames, (Object)requiredPlatformVersion);
                        continue;
                    }
                }
                if (!this.getApplicationContext().containsBean(beanName)) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Could not find service \"{}\". This service will not be registered in the OSGI container.", (Object)beanName);
                    continue;
                }
                if (!this.getApplicationContext().isSingleton(beanName)) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(String.format("Service \"%s\" is not a singleton. Can only register singleton beans.", beanName));
                    continue;
                }
                Object service = this.getApplicationContext().getBean(beanName);
                if (service == null) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Cannot find bean '{}'", (Object)beanName);
                    continue;
                }
                try {
                    ServiceRegistration<?> serviceRegistration = this.registerService(bundleContext, service, serviceNames, beanName, serviceDefinition.getServiceType(), serviceRanking);
                    --serviceRanking;
                    this.serviceRegistrations.add(serviceRegistration);
                }
                catch (RuntimeException e) {
                    this.logger.error("Could not register bean \"{} \" as service", (Object)beanName);
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Registered {} OSGI services.", (Object)this.serviceRegistrations.size());
        }
        return Collections.unmodifiableList(this.serviceRegistrations);
    }

    protected ServiceRegistration<?> registerService(BundleContext bundleContext, Object service, List<String> serviceNames, String beanName, String serviceType, int serviceRanking) {
        Assert.notNull((Object)service, (String)"Service cannot be null.");
        Assert.notEmpty(serviceNames, (String)"Service names cannot be empty.");
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        serviceProperties.put(OSGI_SERVICE_BLUEPRINT_COMPNAME, beanName);
        serviceProperties.put("hostApplication", "alfresco");
        if (StringUtils.hasText((String)serviceType)) {
            serviceProperties.put(ALFRESCO_SERVICE_TYPE, serviceType);
        }
        serviceProperties.put("service.ranking", serviceRanking);
        for (ServicePropertiesProvider servicePropertiesProvider : this.getServicePropertiesProviders()) {
            Map<String, Object> props = servicePropertiesProvider.getServiceProperties(service, serviceNames);
            if (CollectionUtils.isEmpty(props)) continue;
            serviceProperties.putAll(props);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering bean \"{}\" under service names {} with properties {}", new Object[]{beanName, serviceNames, serviceProperties});
        }
        return bundleContext.registerService(serviceNames.toArray(new String[serviceNames.size()]), service, serviceProperties);
    }

    public void unregisterFromBundleContext() {
        for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unregistering service: {}", serviceRegistration.getReference().getProperty("objectClass"));
                }
                serviceRegistration.unregister();
            }
            catch (RuntimeException e) {
                this.logger.error("Error unregistering service.", (Throwable)e);
            }
        }
        this.serviceRegistrations.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    protected DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    @Required
    public void setServiceDefinitions(List<ServiceDefinition> serviceDefinitions) {
        Assert.notNull(serviceDefinitions);
        this.serviceDefinitions = serviceDefinitions;
    }

    protected List<ServiceDefinition> getServiceDefinitions() {
        return this.serviceDefinitions;
    }

    public void setServicePropertiesProviders(List<ServicePropertiesProvider> servicePropertiesProviders) {
        Assert.notNull(servicePropertiesProviders);
        this.servicePropertiesProviders = servicePropertiesProviders;
    }

    protected List<ServicePropertiesProvider> getServicePropertiesProviders() {
        return this.servicePropertiesProviders;
    }
}

