/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public class ServiceDefinition {
    private final List<String> beanNames;
    private final List<String> serviceNames;
    private String serviceType;
    private String platformVersion;

    public ServiceDefinition(String[] beanNames, String[] serviceNames, String serviceType, String platformVersion) {
        Assert.notEmpty((Object[])beanNames, (String)"Bean names cannot be empty.");
        Assert.notEmpty((Object[])serviceNames, (String)"Service names cannot be empty.");
        this.beanNames = Arrays.asList(beanNames);
        this.serviceNames = Arrays.asList(serviceNames);
        this.serviceType = serviceType;
        this.platformVersion = platformVersion;
    }

    public ServiceDefinition(String[] beanNames, String[] serviceNames, String serviceType) {
        Assert.notEmpty((Object[])beanNames, (String)"Bean names cannot be empty.");
        Assert.notEmpty((Object[])serviceNames, (String)"Service names cannot be empty.");
        this.beanNames = Arrays.asList(beanNames);
        this.serviceNames = Arrays.asList(serviceNames);
        this.serviceType = serviceType;
    }

    public ServiceDefinition(String beanName, String ... serviceNames) {
        Assert.hasText((String)beanName, (String)"Bean names cannot be empty.");
        Assert.notEmpty((Object[])serviceNames, (String)"Service names cannot be empty.");
        this.beanNames = Arrays.asList(beanName);
        this.serviceNames = Arrays.asList(serviceNames);
    }

    public ServiceDefinition(String[] beanNames, String ... serviceNames) {
        Assert.notEmpty((Object[])beanNames, (String)"Bean names cannot be empty.");
        Assert.notEmpty((Object[])serviceNames, (String)"Service names cannot be empty.");
        this.beanNames = Arrays.asList(beanNames);
        this.serviceNames = Arrays.asList(serviceNames);
    }

    public List<String> getBeanNames() {
        return this.beanNames;
    }

    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }
}

