/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.ServiceDefinition;
import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class ServiceDefinitionEditor
extends PropertyEditorSupport {
    private static final Pattern BEAN_NAME_AND_SERVICE_NAMES_PATTERN = Pattern.compile("(.*?):(.*?)(:(.*?))?(:(\\d+\\.\\d+))?");

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Assert.hasText((String)text, (String)"Text cannot be empty");
        text = text.trim();
        Matcher matcher = BEAN_NAME_AND_SERVICE_NAMES_PATTERN.matcher(text);
        if (matcher.matches()) {
            String[] beanNames = matcher.group(1).split(",");
            String[] serviceNames = matcher.group(2).split(",");
            String serviceType = matcher.group(4);
            String platformVersion = matcher.group(6);
            this.setValue(new ServiceDefinition(beanNames, serviceNames, serviceType, platformVersion));
        }
    }
}

