/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import org.springframework.util.Assert;

public class SystemPackage {
    public static final String DEFAULT_VERSION = "1.0";
    private final String name;
    private final String version;

    public static SystemPackage fromString(String line) {
        String[] tokens = line.split(";");
        if (tokens.length > 1) {
            return new SystemPackage(tokens[0], tokens[1]);
        }
        return new SystemPackage(tokens[0], null);
    }

    public SystemPackage(String name, String version) {
        Assert.hasText((String)name, (String)"Name cannot be empty.");
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        if (this.version != null) {
            return String.format("%s;%s", this.name, this.version);
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemPackage that = (SystemPackage)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

