/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi;

import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemPackageEditor
extends PropertyEditorSupport {
    private static final Pattern PACKAGE_AND_VERSION_PATTERN = Pattern.compile("([a-z0-9\\._]+)\\s*;\\s*(([0-9\\.]+)+)", 2);
    private static final Pattern PACKAGE_ONLY_PATTERN = Pattern.compile("[a-z0-9\\._]+", 2);
    private String defaultVersion;

    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    protected String getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Matcher matcher = PACKAGE_AND_VERSION_PATTERN.matcher(text);
        if (matcher.matches()) {
            String name = matcher.group(1);
            String version = matcher.group(3);
            this.setValue(new SystemPackage(name, version));
        } else {
            matcher = PACKAGE_ONLY_PATTERN.matcher(text);
            if (matcher.matches()) {
                this.setValue(new SystemPackage(text, this.getDefaultVersion()));
            } else {
                throw new IllegalArgumentException(String.format("Unrecognized value: %s", text));
            }
        }
    }
}

