/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public abstract class AbstractConfigurationFileFactoryBean<T>
implements FactoryBean<T>,
ResourceLoaderAware {
    private ResourcePatternResolver resourcePatternResolver;
    private List<Resource> configurations = Collections.emptyList();
    private List<String> configurationLocations = Collections.emptyList();

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.isInstanceOf(ResourcePatternResolver.class, (Object)resourceLoader);
        this.resourcePatternResolver = (ResourcePatternResolver)resourceLoader;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return this.resourcePatternResolver;
    }

    protected List<Resource> resolveConfigurations() throws IOException {
        ArrayList<Resource> configurations = new ArrayList<Resource>(this.configurations);
        for (String location : this.getConfigurationLocations()) {
            configurations.addAll(Arrays.asList(this.getResourcePatternResolver().getResources(location)));
        }
        return configurations;
    }

    public void setConfigurations(List<Resource> configurations) {
        Assert.notNull(configurations);
        this.configurations = configurations;
    }

    protected List<Resource> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurationLocations(List<String> configurationLocations) {
        this.configurationLocations = configurationLocations;
    }

    protected List<String> getConfigurationLocations() {
        return this.configurationLocations;
    }
}

