/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ChildApplicationContextFactoryBean
implements FactoryBean<ClassPathXmlApplicationContext>,
ApplicationContextAware {
    private ApplicationContext parentApplicationContext;
    private String[] configLocations;
    private boolean createSingletons = true;
    private ClassPathXmlApplicationContext childApplicationContext;

    public boolean isSingleton() {
        return this.createSingletons;
    }

    public Class<? extends ClassPathXmlApplicationContext> getObjectType() {
        return ClassPathXmlApplicationContext.class;
    }

    public ClassPathXmlApplicationContext getObject() {
        if (this.isCreateSingletons()) {
            if (this.childApplicationContext == null) {
                this.childApplicationContext = this.createOsgiContainerApplicationContext();
            }
            return this.childApplicationContext;
        }
        return this.createOsgiContainerApplicationContext();
    }

    public void destroy() {
        this.closeOsgiContainerApplicationContext();
    }

    protected ClassPathXmlApplicationContext createOsgiContainerApplicationContext() {
        return new ClassPathXmlApplicationContext(this.getConfigLocations(), this.getParentApplicationContext());
    }

    protected void closeOsgiContainerApplicationContext() {
        if (this.childApplicationContext != null) {
            this.childApplicationContext.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentApplicationContext = applicationContext;
    }

    protected ApplicationContext getParentApplicationContext() {
        return this.parentApplicationContext;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    public void setCreateSingletons(boolean createSingletons) {
        this.createSingletons = createSingletons;
    }

    public boolean isCreateSingletons() {
        return this.createSingletons;
    }
}

