/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import com.github.dynamicextensionsalfresco.osgi.ConfigurationValues;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class ConfigurationValuesFactoryBean<T>
implements FactoryBean<ConfigurationValues<T>> {
    private List<Set<T>> sets;
    private ConfigurationValues<T> instance;

    public boolean isSingleton() {
        return true;
    }

    public Class getObjectType() {
        return ConfigurationValues.class;
    }

    public ConfigurationValues<T> getObject() throws Exception {
        if (this.instance == null) {
            this.instance = this.createContainerConfiguration();
        }
        return this.instance;
    }

    protected ConfigurationValues<T> createContainerConfiguration() {
        LinkedHashSet<T> items = new LinkedHashSet<T>(this.getTotalSize());
        for (Set<T> set : this.getSets()) {
            items.addAll(set);
        }
        return new ConfigurationValues(items);
    }

    protected int getTotalSize() {
        int totalSize = 0;
        for (Set<T> set : this.getSets()) {
            totalSize += set.size();
        }
        return totalSize;
    }

    public void setSets(List<Set<T>> sets) {
        Assert.notNull(sets);
        this.sets = sets;
    }

    protected List<Set<T>> getSets() {
        return this.sets;
    }
}

