/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import com.github.dynamicextensionsalfresco.osgi.ServiceDefinition;
import com.github.dynamicextensionsalfresco.osgi.ServiceDefinitionEditor;
import com.github.dynamicextensionsalfresco.osgi.spring.AbstractConfigurationFileFactoryBean;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ServiceDefinitionConfigurationFactoryBean
extends AbstractConfigurationFileFactoryBean<List<ServiceDefinition>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ServiceDefinition> serviceDefinitions;

    public Class<? extends List<ServiceDefinition>> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<ServiceDefinition> getObject() throws IOException {
        if (this.serviceDefinitions == null) {
            this.serviceDefinitions = this.createServiceDefinitions();
        }
        return this.serviceDefinitions;
    }

    protected List<ServiceDefinition> createServiceDefinitions() throws IOException {
        ArrayList<ServiceDefinition> serviceDefinitions = new ArrayList<ServiceDefinition>();
        ServiceDefinitionEditor serviceDefinitionEditor = new ServiceDefinitionEditor();
        for (Resource configuration : this.resolveConfigurations()) {
            String line;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(configuration.getInputStream()));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                try {
                    serviceDefinitionEditor.setAsText(line);
                    ServiceDefinition serviceDefinition = (ServiceDefinition)serviceDefinitionEditor.getValue();
                    serviceDefinitions.add(serviceDefinition);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Could not parse SystemPackage configuration line: {}", (Object)e.getMessage());
                }
            }
        }
        return serviceDefinitions;
    }
}

