/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import com.github.dynamicextensionsalfresco.osgi.SystemPackageEditor;
import com.github.dynamicextensionsalfresco.osgi.spring.AbstractConfigurationFileFactoryBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SystemPackageConfigurationFactoryBean
extends AbstractConfigurationFileFactoryBean<Set<SystemPackage>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String defaultVersion;
    private Set<SystemPackage> systemPackages;

    public Class<? extends Set<SystemPackage>> getObjectType() {
        return Set.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Set<SystemPackage> getObject() throws IOException {
        if (this.systemPackages == null) {
            this.systemPackages = this.createSystemPackages();
        }
        return this.systemPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<SystemPackage> createSystemPackages() throws IOException {
        LinkedHashSet<SystemPackage> systemPackages = new LinkedHashSet<SystemPackage>();
        SystemPackageEditor systemPackageEditor = new SystemPackageEditor();
        systemPackageEditor.setDefaultVersion(this.getDefaultVersion());
        for (Resource configuration : this.resolveConfigurations()) {
            BufferedReader in = null;
            try {
                String line;
                in = new LineNumberReader(new InputStreamReader(configuration.getInputStream()));
                while ((line = ((LineNumberReader)in).readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    try {
                        systemPackageEditor.setAsText(line);
                        SystemPackage systemPackage = (SystemPackage)systemPackageEditor.getValue();
                        systemPackages.add(systemPackage);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Could not parse SystemPackage configuration line: {}", (Object)e.getMessage());
                    }
                }
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return systemPackages;
    }

    public void setDefaultVersion(String defaultVersion) {
        Assert.hasText((String)defaultVersion);
        this.defaultVersion = defaultVersion;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }
}

