/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.spring;

import com.github.dynamicextensionsalfresco.osgi.Configuration;
import com.github.dynamicextensionsalfresco.osgi.JavaPackageScanner;
import com.github.dynamicextensionsalfresco.osgi.PackageCacheMode;
import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class WebApplicationSystemPackageFactoryBean
implements FactoryBean<Set<SystemPackage>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectFactory<JavaPackageScanner> javaPackageScanner;
    private Configuration configuration;

    public boolean isSingleton() {
        return true;
    }

    public Class<? extends Set<SystemPackage>> getObjectType() {
        return Set.class;
    }

    public Set<SystemPackage> getObject() {
        long start = System.currentTimeMillis();
        Set<SystemPackage> systemPackages = this.createSystemPackages();
        long finish = System.currentTimeMillis();
        if (finish - start > 1500L) {
            this.logger.info("System Package scanning took '{}' milliseconds. Possible improvement: enable System Package cache by adding 'osgi.container.system-package-cache.mode:ENABLE' to 'osgi-container.properties'", (Object)(finish - start));
        }
        return systemPackages;
    }

    protected Set<SystemPackage> createSystemPackages() {
        File cacheFile;
        JavaPackageScanner packageScanner = (JavaPackageScanner)this.javaPackageScanner.getObject();
        boolean validCache = packageScanner.isCacheValid(this.configuration.getSystemPackageCache());
        Set<SystemPackage> packages = validCache ? this.getCachedPackages() : Collections.emptySet();
        boolean cacheDoesNotExist = CollectionUtils.isEmpty(packages);
        PackageCacheMode packageCacheMode = this.configuration.getSystemPackageCacheMode();
        if (!packageCacheMode.isReadFromCache() || cacheDoesNotExist || !validCache) {
            packages = packageScanner.scanWebApplicationPackages();
        }
        if (packageCacheMode.isForceWriteToCache() || cacheDoesNotExist && packageCacheMode.isWriteToCache()) {
            this.writeCachedPackages(packages);
        }
        if (!packageCacheMode.isWriteToCache() && (cacheFile = this.configuration.getSystemPackageCache()).isFile()) {
            cacheFile.delete();
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SystemPackage> getCachedPackages() {
        File packageCache = this.configuration.getSystemPackageCache();
        if (packageCache.isFile()) {
            LinkedHashSet<SystemPackage> linkedHashSet;
            LineNumberReader in = new LineNumberReader(new InputStreamReader(new FileInputStream(packageCache)));
            try {
                String line;
                LinkedHashSet<SystemPackage> systemPackages = new LinkedHashSet<SystemPackage>(4500, 0.1f);
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    systemPackages.add(SystemPackage.fromString(line));
                }
                linkedHashSet = systemPackages;
            }
            catch (IOException e) {
                try {
                    try {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Error reading cached system package configuration from repository: {}.", (Object)e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)in);
                    }
                }
                catch (IOException e2) {
                    this.logger.warn("Failed to open Java packages cache reader", (Throwable)e2);
                }
            }
            IOUtils.closeQuietly((Reader)in);
            return linkedHashSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachedPackages(Set<SystemPackage> packages) {
        File packageCache = this.configuration.getSystemPackageCache();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(packageCache));
            for (SystemPackage systemPackage : packages) {
                writer.println(systemPackage.toString());
            }
            this.logger.debug("Wrote system package list to {}.", (Object)packageCache.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            try {
                this.logger.warn("Failed t");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void setJavaPackageScanner(ObjectFactory<JavaPackageScanner> javaPackageScanner) {
        Assert.notNull(javaPackageScanner);
        this.javaPackageScanner = javaPackageScanner;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

