/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.webscripts;

import com.github.dynamicextensionsalfresco.osgi.webscripts.SearchPathRegistry;
import java.lang.reflect.Field;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.util.Assert;

public class SearchPathRegistryImpl
implements SearchPathRegistry {
    private SearchPath searchPath;

    @Required
    public void setSearchPath(SearchPath searchPath) {
        Assert.notNull((Object)searchPath);
        this.searchPath = searchPath;
    }

    @Override
    public void addStore(Store store) {
        Collection<Store> stores = this.getStores();
        if (!stores.contains(store)) {
            stores.add(store);
        }
    }

    @Override
    public void removeStore(Store store) {
        Collection<Store> stores = this.getStores();
        if (stores.contains(store)) {
            stores.remove(store);
        }
    }

    protected Collection<Store> getStores() {
        try {
            Field searchPathField = SearchPath.class.getDeclaredField("searchPath");
            searchPathField.setAccessible(true);
            return (Collection)searchPathField.get(this.searchPath);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

