/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.osgi.webscripts;

import com.github.dynamicextensionsalfresco.osgi.webscripts.SearchPathRegistry;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.util.Assert;

public class SearchPathRegistryManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SearchPathRegistry searchPathRegistry;
    private TemplateProcessor templateProcessor;
    private List<Store> stores = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStores() {
        Assert.state((this.getSearchPathRegistry() != null ? 1 : 0) != 0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering {} stores with the SearchPathRegistry.", (Object)this.getStores().size());
        }
        TemplateProcessor templateProcessor = this.templateProcessor;
        synchronized (templateProcessor) {
            for (Store store : this.getStores()) {
                this.getSearchPathRegistry().addStore(store);
            }
            this.resetTemplateProcessor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStores() {
        Assert.state((this.getSearchPathRegistry() != null ? 1 : 0) != 0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unregistering {} stores with the SearchPathRegistry.", (Object)this.getStores().size());
        }
        TemplateProcessor templateProcessor = this.templateProcessor;
        synchronized (templateProcessor) {
            for (Store store : this.getStores()) {
                this.getSearchPathRegistry().removeStore(store);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTemplateProcessor() {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(TemplateProcessor.class.getClassLoader());
        try {
            this.templateProcessor.reset();
        }
        catch (Exception ex) {
            this.logger.warn("failed to reset template processor cache", (Throwable)ex);
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    public void setSearchPathRegistry(SearchPathRegistry searchPathRegistry) {
        this.searchPathRegistry = searchPathRegistry;
    }

    protected SearchPathRegistry getSearchPathRegistry() {
        return this.searchPathRegistry;
    }

    public void setTemplateProcessor(TemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    public void setStores(List<Store> stores) {
        Assert.notNull(stores);
        this.stores = stores;
    }

    public List<Store> getStores() {
        return this.stores;
    }
}

