/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.proxy;

import com.github.dynamicextensionsalfresco.proxy.FilterModel;
import java.util.List;
import org.apache.felix.framework.FilterImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class DefaultFilterModel
implements FilterModel {
    private final List<Class<?>> targetInterfaces;
    private Filter filter;

    public DefaultFilterModel(List<Class<?>> targetInterfaces, Filter filter) {
        this.targetInterfaces = targetInterfaces;
        this.filter = filter;
    }

    @Override
    public Filter getServiceFilter() {
        if (this.filter == null) {
            StringBuilder builder = new StringBuilder("(&");
            for (Class<?> targetInterface : this.targetInterfaces) {
                builder.append("(").append("objectClass").append("=").append(targetInterface.getName()).append(")");
            }
            builder.append(")");
            try {
                this.filter = new FilterImpl(builder.toString());
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.filter;
    }

    @Override
    public void setServiceFilter(Filter serviceFilter) {
        this.filter = serviceFilter;
    }

    @Override
    public void setServiceFilterString(String ldapFilter) {
        try {
            this.filter = new FilterImpl(ldapFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

