/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.proxy;

import com.github.dynamicextensionsalfresco.osgi.FrameworkManager;
import com.github.dynamicextensionsalfresco.osgi.FrameworkService;
import com.github.dynamicextensionsalfresco.proxy.FilterModel;
import com.github.dynamicextensionsalfresco.proxy.ServiceInvoker;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final Logger logger = LoggerFactory.getLogger(Tracker.class);
    private final FilterModel filterModel;
    private final FrameworkService frameworkService;
    private volatile ServiceTracker<Object, Object> serviceTracker;
    private volatile FrameworkManager frameworkManager;

    public Tracker(FilterModel filterModel, FrameworkService frameworkService) {
        this.filterModel = filterModel;
        this.frameworkService = frameworkService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object invokeUsing(ServiceInvoker<T> serviceInvoker) throws Throwable {
        block13: {
            try {
                if (this.frameworkManager != null && this.frameworkManager != this.frameworkService.getFrameworkManager()) {
                    this.closeServiceTracker();
                    this.frameworkManager = null;
                }
                if (this.serviceTracker != null) break block13;
                Tracker tracker = this;
                synchronized (tracker) {
                    if (this.serviceTracker == null) {
                        if (this.frameworkManager == null) {
                            this.frameworkManager = this.frameworkService.getFrameworkManager();
                        }
                        this.serviceTracker = new ServiceTracker(this.frameworkManager.getFramework().getBundleContext(), this.filterModel.getServiceFilter(), null);
                        this.serviceTracker.open(true);
                        logger.debug("Opened servicetracker using filter {}.", (Object)this.filterModel.getServiceFilter());
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("OSGi Framework is not ready yet.", e);
            }
        }
        ServiceReference[] serviceReferences = this.serviceTracker.getServiceReferences();
        if (serviceReferences == null) {
            throw new IllegalStateException(String.format("No Dynamic service found using filter %s.", this.filterModel.getServiceFilter()));
        }
        if (serviceReferences.length != 1) {
            throw new IllegalStateException(String.format("More then 1 service found using filter %s.", this.filterModel.getServiceFilter()));
        }
        ServiceReference soleReference = serviceReferences[0];
        Object service = this.serviceTracker.getService(soleReference);
        try {
            Object object = serviceInvoker.invokeService(service);
            return object;
        }
        finally {
            this.serviceTracker.removedService(soleReference, service);
        }
    }

    private synchronized void closeServiceTracker() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
            this.serviceTracker = null;
            logger.debug("Closed servicetracker using filter {}.", (Object)this.filterModel.getServiceFilter());
        }
    }

    public FilterModel getFilterModel() {
        return new FilterModel(){

            @Override
            public Filter getServiceFilter() {
                return Tracker.this.filterModel.getServiceFilter();
            }

            @Override
            public void setServiceFilter(Filter serviceFilter) {
                Tracker.this.filterModel.setServiceFilter(serviceFilter);
                Tracker.this.closeServiceTracker();
            }

            @Override
            public void setServiceFilterString(String ldapFilter) {
                Tracker.this.filterModel.setServiceFilterString(ldapFilter);
                Tracker.this.closeServiceTracker();
            }
        };
    }
}

