/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.workflow;

import com.github.dynamicextensionsalfresco.resources.BootstrapService;
import com.github.dynamicextensionsalfresco.resources.ContentCompareStrategy;
import com.github.dynamicextensionsalfresco.resources.ResourceHelper;
import com.github.dynamicextensionsalfresco.resources.UpdateStrategy;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class WorkflowDefinitionRegistrar
implements InitializingBean {
    private static final String workflowLocationPattern = "osgibundle:/META-INF/alfresco/workflows/*.bpmn20.xml";
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionRegistrar.class);
    @Autowired
    protected RepositoryLocation customWorkflowDefsRepositoryLocation;
    @Autowired
    protected ResourceHelper resourceHelper;
    @Autowired
    protected BootstrapService bootstrapService;
    @Autowired
    protected NodeService nodeService;
    @Autowired
    protected TransactionService transactionService;

    public void afterPropertiesSet() throws Exception {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    WorkflowDefinitionRegistrar.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        public Object execute() throws Throwable {
                            Map deployed = WorkflowDefinitionRegistrar.this.bootstrapService.deployResources(WorkflowDefinitionRegistrar.workflowLocationPattern, WorkflowDefinitionRegistrar.this.customWorkflowDefsRepositoryLocation, (UpdateStrategy)new ContentCompareStrategy(WorkflowDefinitionRegistrar.this.resourceHelper), "UTF-8", "text/xml", WorkflowModel.TYPE_WORKFLOW_DEF);
                            for (Map.Entry entry : deployed.entrySet()) {
                                NodeRef nodeRef = (NodeRef)entry.getValue();
                                if (Boolean.TRUE.equals(WorkflowDefinitionRegistrar.this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED))) continue;
                                Resource workflowDefinition = (Resource)entry.getKey();
                                String fileName = workflowDefinition.getFilename();
                                WorkflowDefinitionRegistrar.this.nodeService.setProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_ENGINE_ID, (Serializable)((Object)"activiti"));
                                WorkflowDefinitionRegistrar.this.nodeService.setProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_NAME, (Serializable)((Object)fileName));
                                WorkflowDefinitionRegistrar.this.nodeService.setProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME, (Serializable)((Object)fileName));
                                WorkflowDefinitionRegistrar.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, (Map)ImmutableMap.builder().put((Object)ContentModel.PROP_TITLE, (Object)fileName).build());
                                WorkflowDefinitionRegistrar.this.nodeService.setProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEF_DEPLOYED, (Serializable)Boolean.valueOf(true));
                            }
                            return null;
                        }
                    }, false, false);
                }
                catch (Exception e) {
                    logger.error("tx error", (Throwable)e);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }
}

