/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.event.impl;

import com.github.dynamicextensionsalfresco.event.Event;
import com.github.dynamicextensionsalfresco.event.EventBus;
import com.github.dynamicextensionsalfresco.event.EventListener;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class DefaultEventBus
implements EventBus {
    private final BundleContext bundleContext;

    public DefaultEventBus(@NotNull BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext is null");
        }
        this.bundleContext = bundleContext;
    }

    @Override
    public void publish(@NotNull Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences(EventListener.class.getName(), null);
            if (serviceReferences == null || serviceReferences.length == 0) {
                return;
            }
            Arrays.stream(serviceReferences).map(arg_0 -> ((BundleContext)this.bundleContext).getService(arg_0)).filter(e -> e instanceof EventListener).filter(e -> Arrays.stream(((EventListener)e).supportedEventTypes()).anyMatch(it -> it == event.getClass())).forEach(e -> ((EventListener)e).onEvent(event));
        }
        catch (InvalidSyntaxException e2) {
            throw new IllegalStateException("Strange, 'InvalidSyntaxException' should not be thrown if filter is null?", e2);
        }
    }
}

