/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.ResponseHelper;
import com.github.dynamicextensionsalfresco.osgi.Configuration;
import com.github.dynamicextensionsalfresco.osgi.ConfigurationValues;
import com.github.dynamicextensionsalfresco.osgi.SystemPackage;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Before;
import com.github.dynamicextensionsalfresco.webscripts.annotations.ExceptionHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

abstract class AbstractControlPanelHandler {
    private static final String[] FLASH_VARIABLES = new String[]{"installedBundle", "successMessage", "errorMessage"};
    @Autowired
    protected Configuration osgiConfiguration;
    @Resource(name="osgi.container.SystemPackages")
    private ConfigurationValues<SystemPackage> systemPackages;

    AbstractControlPanelHandler() {
    }

    @Attribute
    protected ResponseHelper getResponseHelper(WebScriptRequest request, WebScriptResponse response) {
        return new ResponseHelper(request, response, this.osgiConfiguration);
    }

    @Attribute(value="configuration")
    protected Configuration getConfiguration() {
        return this.osgiConfiguration;
    }

    @Attribute(value="currentUser")
    protected String getCurrentUser() {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    @Before
    protected void addFlashMessagesToModel(@Attribute ResponseHelper responseHelper, Map<String, Object> model) {
        for (String variable : FLASH_VARIABLES) {
            model.put(variable, responseHelper.getFlashVariable(variable));
        }
    }

    @ExceptionHandler(value={WebScriptException.class})
    protected void handleWebscriptException(WebScriptException wx, @Attribute ResponseHelper responseHelper) throws IOException {
        responseHelper.flashErrorMessage(wx.getMessage(), (Exception)wx);
    }

    protected Collection<SystemPackage> getSystemPackages() {
        return this.systemPackages.getValues();
    }

    protected Map<String, Object> model(String name, Object value) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(name, value);
        return model;
    }
}

