/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import aQute.bnd.osgi.Analyzer;
import com.github.dynamicextensionsalfresco.controlpanel.BundleIdentifier;
import com.github.dynamicextensionsalfresco.event.EventListener;
import com.github.dynamicextensionsalfresco.event.events.SpringContextException;
import com.github.dynamicextensionsalfresco.osgi.BundleDependencies;
import com.github.dynamicextensionsalfresco.osgi.ManifestUtils;
import com.github.dynamicextensionsalfresco.osgi.RepositoryStoreService;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleManifestFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.DeclarativeRegistry;
import org.springframework.extensions.webscripts.GUID;
import org.springframework.extensions.webscripts.Registry;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

@Component
public class BundleHelper
implements EventListener<SpringContextException>,
FrameworkListener {
    private static Logger logger = LoggerFactory.getLogger(BundleHelper.class);
    @Autowired
    private BundleContext bundleContext = null;
    @Autowired
    private RepositoryStoreService repositoryStoreService = null;
    @Autowired
    private FileFolderService fileFolderService = null;
    @Autowired
    private ContentService contentService = null;
    @Autowired
    private NodeService nodeService = null;
    @Autowired
    @Resource(name="webscripts.container")
    private Container webScriptsContainer = null;
    private ConcurrentLinkedQueue<Bundle> bundlesToStart = new ConcurrentLinkedQueue();
    private LinkedBlockingDeque<InstallResult> installResults = new LinkedBlockingDeque();

    public BundleHelper() {
    }

    public BundleHelper(BundleContext bundleContext, RepositoryStoreService repositoryStoreService, FileFolderService fileFolderService, ContentService contentService, NodeService nodeService, Container webScriptsContainer) {
        this.bundleContext = bundleContext;
        this.repositoryStoreService = repositoryStoreService;
        this.fileFolderService = fileFolderService;
        this.contentService = contentService;
        this.nodeService = nodeService;
        this.webScriptsContainer = webScriptsContainer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getBundleRepositoryLocation() {
        return this.repositoryStoreService.getBundleRepositoryLocation();
    }

    @PostConstruct
    public ServiceRegistration registerEventListeners() {
        return this.bundleContext.registerService(EventListener.class, (Object)this, null);
    }

    public List<Bundle> getFrameworkBundles() {
        return Arrays.stream(this.bundleContext.getBundles()).filter(bundle -> BundleHelperCompanion.isDynamicExtension(bundle) == false).collect(Collectors.toList());
    }

    public List<Bundle> getExtensionBundles() {
        return Arrays.stream(this.bundleContext.getBundles()).filter(bundle -> BundleHelperCompanion.isDynamicExtension(bundle)).collect(Collectors.toList());
    }

    public Bundle getBundle(Long id) {
        return this.bundleContext.getBundle(id.longValue());
    }

    public Bundle installBundleInRepository(FormData.FormField file) throws IOException, BundleException {
        return this.installBundleInRepository(file.getContent());
    }

    public Bundle installBundleInRepository(Content content) throws IOException, BundleException {
        try (InputStream stream = content.getInputStream();){
            File tempFile = this.saveToTempFile(stream);
            Bundle bundle = this.doInstallBundleInRepository(tempFile, null);
            return bundle;
        }
    }

    public NodeRef uninstallAndDeleteBundle(Bundle bundle) throws BundleException {
        NodeRef matchingNode = null;
        if (bundle == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("/Company Home(/.+)+/(.+\\.jar)$").matcher(bundle.getLocation());
        if (matcher.matches()) {
            NodeRef file;
            String filename = matcher.group(2);
            NodeRef bundleFolder = this.repositoryStoreService.getBundleFolder(false);
            if (bundleFolder != null && (file = this.fileFolderService.searchSimple(bundleFolder, filename)) != null) {
                HashMap properties = new HashMap();
                this.nodeService.addAspect(file, ContentModel.ASPECT_TEMPORARY, properties);
                this.nodeService.deleteNode(file);
                matchingNode = file;
                bundle.uninstall();
            }
        }
        return matchingNode;
    }

    public ServiceReference<?>[] getAllServices() throws InvalidSyntaxException {
        return this.bundleContext.getAllServiceReferences(null, null);
    }

    <T> T getService(Class<T> service) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(service);
        if (serviceReference != null) {
            return (T)this.bundleContext.getService(serviceReference);
        }
        return null;
    }

    protected FrameworkWiring getFrameworkWiring() {
        return (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Bundle doInstallBundleInRepository(File tempFile, String fileName) throws BundleException {
        File jarToInstall = tempFile;
        this.installResults.clear();
        try {
            BundleIdentifier identifier = this.getBundleIdentifier(jarToInstall);
            if (identifier == null) {
                jarToInstall = this.wrapPlainJar(tempFile, fileName);
                identifier = this.getBundleIdentifier(jarToInstall);
                if (identifier == null) {
                    throw new BundleException("Could not generate Bundle filename. Make sure the content is an OSGi bundle.");
                }
                String symbolicName = identifier.getSymbolicName();
                logger.info("Wrapped plain jar as a OSGi bundle: {}.", (Object)symbolicName);
            }
            fileName = identifier.toJarFilename();
            String location = this.generateRepositoryLocation(fileName);
            Bundle bundle = this.bundleContext.getBundle(location);
            boolean classpathBundle = false;
            if (bundle == null && (bundle = this.findBundleBySymbolicName(identifier)) != null) {
                NodeRef deletedNode = this.uninstallAndDeleteBundle(bundle);
                if (deletedNode != null) {
                    logger.warn("Deleted existing repository bundle {} with an identical Symbolic name: {}.", (Object)deletedNode, (Object)identifier.getSymbolicName());
                    bundle = null;
                } else {
                    classpathBundle = true;
                }
            }
            InputStream inputStream = this.createStreamForFile(jarToInstall);
            if (bundle != null) {
                bundle.stop();
                bundle.update(inputStream);
                FrameworkWiring wiring = this.getFrameworkWiring();
                HashSet<Bundle> bundleSet = new HashSet<Bundle>();
                bundleSet.add(bundle);
                wiring.resolveBundles(bundleSet);
                if (this.isFragmentBundle(bundle).booleanValue()) {
                    return bundle;
                }
                this.bundlesToStart.offer(bundle);
                Bundle[] dependantBundles = (Bundle[])wiring.getDependencyClosure(bundleSet).stream().filter(bndl -> bndl.getState() == 32).toArray(Bundle[]::new);
                ArrayList<Bundle> dependantBundlesList = new ArrayList<Bundle>(Arrays.asList(dependantBundles));
                List dependantBundlesSorted = BundleDependencies.sortByDependencies(dependantBundlesList);
                dependantBundlesSorted.sort(Collections.reverseOrder());
                for (Bundle dependant : dependantBundlesSorted) {
                    dependant.stop();
                }
                for (Bundle dependant : dependantBundlesSorted) {
                    this.bundlesToStart.offer(dependant);
                }
                wiring.refreshBundles(bundleSet, new FrameworkListener[]{this});
            } else {
                bundle = this.bundleContext.installBundle(location, inputStream);
                if (!this.isFragmentBundle(bundle).booleanValue()) {
                    bundle.start();
                    this.installResults.add(new InstallResult(null));
                }
            }
            if (bundle == null) return bundle;
            if (!classpathBundle) {
                BundleManifest manifest = this.createBundleManifest(bundle);
                this.saveBundleInRepository(jarToInstall, fileName, manifest);
            } else {
                logger.warn("Temporarily updated classpath bundle: {}, update will be reverted after restart.", (Object)bundle.getSymbolicName());
            }
            try {
                BundleHelperCompanion.evaluateInstallationResult(this.installResults.poll(1L, TimeUnit.MINUTES));
            }
            catch (InterruptedException tx) {
                logger.warn("Timed out waiting for an installation result", (Throwable)tx);
            }
            this.resetWebScriptsCache();
            return bundle;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected BundleManifest createBundleManifest(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return BundleManifestFactory.createBundleManifest((Dictionary)bundle.getHeaders());
    }

    protected InputStream createStreamForFile(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private File wrapPlainJar(File tempFile, String fileName) {
        try {
            String name;
            JarFile jar = new JarFile(tempFile);
            Analyzer analyzer = new Analyzer();
            String manifestVersion = ManifestUtils.getImplementationVersion((JarFile)jar);
            if (manifestVersion != null) {
                analyzer.setBundleVersion(manifestVersion);
            }
            if ((name = ManifestUtils.getImplementationTitle((JarFile)jar)) == null) {
                if (fileName == null) {
                    return tempFile;
                }
                name = fileName.replaceFirst("^(.+)\\.\\w+$", "$1");
            }
            analyzer.setBundleSymbolicName(name);
            analyzer.setJar(tempFile);
            analyzer.setImportPackage("*;resolution:=optional");
            analyzer.setExportPackage("*");
            analyzer.analyze();
            Manifest manifest = analyzer.calcManifest();
            analyzer.getJar().setManifest(manifest);
            File wrappedTempFile = File.createTempFile("wrapped", ".jar");
            analyzer.save(wrappedTempFile, true);
            return wrappedTempFile;
        }
        catch (Exception e) {
            logger.warn("Failed to wrap plain $tempFile jar using bnd.", (Throwable)e);
            return tempFile;
        }
    }

    protected Bundle findBundleBySymbolicName(BundleIdentifier identifier) throws BundleException {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle == null || !bundle.getSymbolicName().equals(identifier.getSymbolicName())) continue;
            return bundle;
        }
        return null;
    }

    protected File saveToTempFile(InputStream data) throws IOException {
        File tempFile = File.createTempFile("dynamic-extensions-bundle", GUID.generate());
        tempFile.deleteOnExit();
        try (FileOutputStream outputStream = new FileOutputStream(tempFile, false);){
            StreamUtils.copy((InputStream)data, (OutputStream)outputStream);
            File file = tempFile;
            return file;
        }
    }

    protected BundleIdentifier getBundleIdentifier(File tempFile) throws IOException {
        BundleIdentifier identifier = null;
        try (JarFile jarFile = new JarFile(tempFile);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String symbolicName = attributes.getValue("Bundle-SymbolicName");
            String version = attributes.getValue("Bundle-Version");
            if (StringUtils.hasText((String)symbolicName) && StringUtils.hasText((String)version)) {
                identifier = BundleIdentifier.fromSymbolicNameAndVersion(symbolicName, version);
            }
            BundleIdentifier bundleIdentifier = identifier;
            return bundleIdentifier;
        }
    }

    protected void saveBundleInRepository(File file, String filename, BundleManifest manifest) throws FileNotFoundException {
        NodeRef bundleFolder = this.repositoryStoreService.getBundleFolder(true);
        NodeRef nodeRef = this.fileFolderService.searchSimple(bundleFolder, filename);
        if (nodeRef == null) {
            nodeRef = this.fileFolderService.create(bundleFolder, filename, ContentModel.TYPE_CONTENT).getNodeRef();
        }
        String title = String.format("%s %s", manifest.getBundleName(), manifest.getBundleVersion());
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)title));
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)manifest.getBundleDescription()));
        HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
        props.put(ContentModel.PROP_IS_INDEXED, false);
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL, props);
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("application/zip");
        writer.putContent(this.createStreamForFile(file));
    }

    protected String generateRepositoryLocation(String filename) {
        return String.format("%s/%s", this.getBundleRepositoryLocation(), filename);
    }

    protected Boolean isFragmentBundle(Bundle bundle) {
        return bundle != null && bundle.getHeaders().get("Fragment-Host") != null;
    }

    protected void resetWebScriptsCache() {
        Registry registry = this.webScriptsContainer.getRegistry();
        if (registry instanceof DeclarativeRegistry) {
            try {
                Field cacheField = DeclarativeRegistry.class.getDeclaredField("uriIndexCache");
                if (!cacheField.isAccessible()) {
                    cacheField.setAccessible(true);
                }
                AbstractMap cache = (AbstractMap)cacheField.get(registry);
                cache.clear();
            }
            catch (Exception e) {
                logger.error("failed to reset webscript cache", (Throwable)e);
            }
        }
    }

    public void onEvent(SpringContextException event) {
        this.installResults.add(new InstallResult(event.getException()));
    }

    public Class<?>[] supportedEventTypes() {
        return new Class[]{SpringContextException.class};
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            Bundle bundle = this.bundlesToStart.poll();
            while (bundle != null) {
                try {
                    bundle.start();
                    this.installResults.add(new InstallResult(null));
                }
                catch (BundleException bx) {
                    this.installResults.add(new InstallResult((Exception)((Object)bx)));
                }
                bundle = this.bundlesToStart.poll();
            }
        }
    }

    public static class BundleHelperCompanion {
        private static Logger logger = LoggerFactory.getLogger(BundleHelperCompanion.class);
        static String ALFRESCO_DYNAMIC_EXTENSION_HEADER = "Alfresco-Dynamic-Extension";

        public static Boolean isDynamicExtension(Bundle bundle) {
            return bundle != null && "true".equals(bundle.getHeaders().get(ALFRESCO_DYNAMIC_EXTENSION_HEADER));
        }

        static void evaluateInstallationResult(InstallResult installResult) throws BundleException {
            if (installResult != null) {
                if (installResult.exception instanceof RuntimeException) {
                    throw (RuntimeException)installResult.exception;
                }
                if (installResult.exception instanceof BundleException) {
                    throw (BundleException)installResult.exception;
                }
            }
        }
    }

    class InstallResult {
        public Exception exception;

        InstallResult(Exception exception) {
            this.exception = exception;
        }
    }
}

