/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.BundleHelper;
import com.github.dynamicextensionsalfresco.osgi.Configuration;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Authentication;
import com.github.dynamicextensionsalfresco.webscripts.annotations.AuthenticationType;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Header;
import com.github.dynamicextensionsalfresco.webscripts.annotations.HttpMethod;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Uri;
import com.github.dynamicextensionsalfresco.webscripts.annotations.WebScript;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.AbstractJsonResolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.Resolution;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.stereotype.Component;

@Component
@WebScript(baseUri="/dynamic-extensions/api/bundles", families={"control panel"})
@Authentication(value=AuthenticationType.ADMIN)
public class BundleRestApi {
    private static final String JAR_MIME_TYPE = "application/java-archive";
    @Autowired
    private BundleHelper bundleHelper;
    @Autowired
    private Configuration configuration;

    @Uri(method=HttpMethod.POST)
    public Resolution installBundle(Content content, @Header(value="Content-Type") String contentType) throws Exception {
        if (!this.configuration.getHotDeployEnabled()) {
            return new JsonMessage(new JSONObject().put("message", (Object)"osgi.container.control-panel.bundle-install is disabled"), 403);
        }
        if (!JAR_MIME_TYPE.equalsIgnoreCase(contentType)) {
            throw new WebScriptException(400, String.format("Can only accept content of type '%s'.", JAR_MIME_TYPE));
        }
        try {
            Bundle bundle = this.bundleHelper.installBundleInRepository(content);
            return new JsonMessage(new JSONObject().put("message", (Object)String.format("Installed bundle %s %s", bundle.getSymbolicName(), bundle.getVersion())).put("bundleId", bundle.getBundleId()), 200);
        }
        catch (Exception e) {
            return new JsonMessage(new JSONObject().put("message", (Object)e.getMessage()), 500);
        }
    }

    private static class JsonMessage
    extends AbstractJsonResolution {
        private final JSONObject jsonObject;

        private JsonMessage(JSONObject jsonObject, Integer status) {
            this.withStatus(status);
            this.jsonObject = jsonObject;
        }

        public void resolve() throws Exception {
            this.getWriter().append(this.jsonObject.toString(2));
        }
    }
}

