/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.AbstractControlPanelHandler;
import com.github.dynamicextensionsalfresco.controlpanel.BundleHelper;
import com.github.dynamicextensionsalfresco.controlpanel.ResponseHelper;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateBundle;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Authentication;
import com.github.dynamicextensionsalfresco.webscripts.annotations.AuthenticationType;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Cache;
import com.github.dynamicextensionsalfresco.webscripts.annotations.FileField;
import com.github.dynamicextensionsalfresco.webscripts.annotations.HttpMethod;
import com.github.dynamicextensionsalfresco.webscripts.annotations.RequestParam;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Uri;
import com.github.dynamicextensionsalfresco.webscripts.annotations.UriVariable;
import com.github.dynamicextensionsalfresco.webscripts.annotations.WebScript;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.RedirectResolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.Resolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.StatusResolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.TemplateResolution;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.webscripts.servlet.FormData;
import org.springframework.stereotype.Component;

@Component
@WebScript(baseUri="/dynamic-extensions/bundles", defaultFormat="html", families={"control panel"})
@Authentication(value=AuthenticationType.ADMIN)
@Cache(neverCache=true)
public class Bundles
extends AbstractControlPanelHandler {
    @Autowired
    private BundleHelper bundleHelper;

    @Uri(method=HttpMethod.GET)
    public Map<String, Object> index(@Attribute ResponseHelper responseHelper) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("extensionBundles", this.toTemplateBundles(this.bundleHelper.getExtensionBundles()));
        model.put("frameworkBundles", this.toTemplateBundles(this.bundleHelper.getFrameworkBundles()));
        return model;
    }

    @Uri(method=HttpMethod.GET, value={"/{id}"})
    public Resolution show(@Attribute Bundle bundle, @Attribute ResponseHelper responseHelper, Map<String, Object> model) throws IOException {
        if (bundle != null) {
            if (bundle.getBundleId() == 0L) {
                model.put("systemPackageCount", this.getSystemPackages().size());
            }
        } else {
            return new StatusResolution(404);
        }
        model.put("bundle", new TemplateBundle(bundle));
        return new TemplateResolution(model);
    }

    @Uri(method=HttpMethod.POST, value={"/install"}, multipartProcessing=true)
    public Resolution install(@FileField FormData.FormField file, @Attribute ResponseHelper responseHelper) throws IOException {
        responseHelper.checkBundleInstallConfiguration();
        if (file != null) {
            if (file.getFilename().endsWith(".jar")) {
                try {
                    Bundle installedBundle = this.bundleHelper.installBundleInRepository(file);
                    responseHelper.setFlashVariable("installedBundle", new TemplateBundle(installedBundle));
                }
                catch (Exception e) {
                    responseHelper.flashErrorMessage(String.format("Error installing Bundle: %s", e.getMessage()), e);
                }
            } else {
                responseHelper.flashErrorMessage(String.format("Not a JAR file: %s", file.getFilename()), null);
            }
        } else {
            responseHelper.flashErrorMessage("No file uploaded.", null);
        }
        return new RedirectResolution("/dynamic-extensions/bundles");
    }

    @Uri(method=HttpMethod.POST, value={"/delete"})
    public Resolution delete(@Attribute Bundle bundle, @Attribute String id, @Attribute ResponseHelper responseHelper) throws IOException {
        responseHelper.checkBundleInstallConfiguration();
        if (bundle != null) {
            try {
                this.bundleHelper.uninstallAndDeleteBundle(bundle);
                String message = String.format("Deleted bundle %s %s", bundle.getHeaders().get("Bundle-Name"), bundle.getVersion());
                responseHelper.flashSuccessMessage(message);
            }
            catch (BundleException e) {
                responseHelper.flashErrorMessage("Error uninstalling Bundle", (Exception)((Object)e));
            }
        } else {
            responseHelper.flashErrorMessage(String.format("Cannot delete bundle. Bundle with ID %s not found.", id), null);
        }
        return new RedirectResolution("/dynamic-extensions/bundles");
    }

    @Uri(method=HttpMethod.POST, value={"/start"})
    public Resolution start(@Attribute Bundle bundle, @Attribute String id, @Attribute ResponseHelper responseHelper) throws IOException {
        responseHelper.checkBundleInstallConfiguration();
        if (bundle != null) {
            try {
                bundle.start();
                String message = String.format("Started bundle %s %s", bundle.getHeaders().get("Bundle-Name"), bundle.getVersion());
                responseHelper.flashSuccessMessage(message);
                return new RedirectResolution("/dynamic-extensions/bundles");
            }
            catch (BundleException e) {
                responseHelper.flashErrorMessage(String.format("Error starting Bundle: %s", e.getMessage()), (Exception)((Object)e));
                return new RedirectToBundle(bundle);
            }
        }
        responseHelper.flashErrorMessage(String.format("Cannot start bundle. Bundle with ID %s not found.", id), null);
        return new RedirectResolution("/dynamic-extensions/bundles");
    }

    protected Collection<TemplateBundle> toTemplateBundles(Collection<Bundle> bundles) {
        ArrayList<TemplateBundle> templateBundles = new ArrayList<TemplateBundle>();
        for (Bundle bundle : bundles) {
            templateBundles.add(new TemplateBundle(bundle));
        }
        Collections.sort(templateBundles);
        return templateBundles;
    }

    @Attribute(value="repositoryStoreLocation")
    protected String getRepositoryStoreLocation() {
        return this.bundleHelper.getBundleRepositoryLocation();
    }

    @Attribute(value="id")
    public Long getId(@UriVariable(required=false) Long pathId) {
        return pathId;
    }

    @Attribute(value="bundle")
    public Bundle getBundle(@UriVariable(value="id", required=false) Long pathId, @RequestParam(value="id", required=false) Long paramId) {
        Long id;
        Long l = id = pathId != null ? pathId : paramId;
        if (id != null) {
            return this.bundleHelper.getBundle(id);
        }
        return null;
    }

    private static class RedirectToBundle
    extends RedirectResolution {
        private RedirectToBundle(Bundle bundle) {
            super(String.format("/dynamic-extensions/bundles/%d", bundle.getBundleId()));
        }
    }
}

