/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.AbstractControlPanelHandler;
import com.github.dynamicextensionsalfresco.controlpanel.BundleHelper;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateBundle;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateServiceReference;
import com.github.dynamicextensionsalfresco.osgi.RepositoryStoreService;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Attribute;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Authentication;
import com.github.dynamicextensionsalfresco.webscripts.annotations.AuthenticationType;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Cache;
import com.github.dynamicextensionsalfresco.webscripts.annotations.HttpMethod;
import com.github.dynamicextensionsalfresco.webscripts.annotations.Uri;
import com.github.dynamicextensionsalfresco.webscripts.annotations.UriVariable;
import com.github.dynamicextensionsalfresco.webscripts.annotations.WebScript;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
@WebScript(baseUri="/dynamic-extensions/container", defaultFormat="html", families={"control panel"})
@Authentication(value=AuthenticationType.ADMIN)
@Cache(neverCache=true)
public class Container
extends AbstractControlPanelHandler {
    @Autowired
    private BundleHelper bundleHelper;
    @Autowired
    private FileFolderService fileFolderService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private RepositoryStoreService repositoryStoreService;

    @Uri(method=HttpMethod.GET)
    public Map<String, Object> index() {
        return Collections.emptyMap();
    }

    @Uri(method=HttpMethod.GET, value={"/system-packages"})
    public Map<String, Object> systemPackages() {
        return this.model("systemPackages", this.getSystemPackages());
    }

    @Uri(method=HttpMethod.GET, value={"/services"})
    public Map<String, Object> services() throws InvalidSyntaxException {
        return this.model("servicesByBundle", this.getTemplateServicesByBundle());
    }

    @Uri(method=HttpMethod.GET, value={"/services/bundle/{bundleid}/{serviceIndex}"})
    public Map<String, Object> service(@UriVariable long bundleid, @UriVariable int serviceIndex) throws InvalidSyntaxException {
        List<TemplateBundle> servicesByBundle = this.getTemplateServicesByBundle();
        TemplateServiceReference serviceReferences = null;
        for (TemplateBundle templateBundle : servicesByBundle) {
            if (templateBundle.getBundleId() != bundleid) continue;
            serviceReferences = templateBundle.getServices().get(serviceIndex);
            break;
        }
        if (serviceReferences != null) {
            ServiceReference serviceReference = serviceReferences.getServiceReference();
            Object context = this.bundleHelper.getBundle(bundleid).getBundleContext().getService(serviceReference);
            if (context instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)context;
                String[] definitionNames = applicationContext.getBeanDefinitionNames();
                HashMap<String, String> beans = new HashMap<String, String>(definitionNames.length);
                for (String name : definitionNames) {
                    try {
                        Object instance = applicationContext.getBean(name);
                        String className = AopUtils.isAopProxy((Object)instance) ? "[Spring Proxy] " + AopUtils.getTargetClass((Object)instance).getName() : (Proxy.isProxyClass(instance.getClass()) ? "[Java Proxy] " + Proxy.getInvocationHandler(instance).getClass().getName() + " -> " + Arrays.toString(ClassUtils.getAllInterfaces((Object)instance)) : instance.getClass().getCanonicalName());
                        beans.put(name, className);
                    }
                    catch (BeanIsAbstractException beanIsAbstractException) {
                        // empty catch block
                    }
                }
                return this.model("contextBeans", beans);
            }
            throw new IllegalArgumentException("Service is not a Spring ApplicationContext, but a " + context.getClass().getName());
        }
        throw new IllegalArgumentException(String.format("No service found for bundle %s at index %s.", bundleid, serviceIndex));
    }

    protected List<TemplateBundle> getTemplateServicesByBundle() throws InvalidSyntaxException {
        Map<Long, List<ServiceReference<Object>>> servicesByBundleId = this.getServicesByBundleId();
        ArrayList<TemplateBundle> templateBundles = new ArrayList<TemplateBundle>(servicesByBundleId.keySet().size());
        for (Map.Entry<Long, List<ServiceReference<Object>>> entry : servicesByBundleId.entrySet()) {
            Bundle bundle = this.bundleHelper.getBundle(entry.getKey());
            List<ServiceReference<Object>> services = servicesByBundleId.get(entry.getKey());
            templateBundles.add(new TemplateBundle(bundle, services));
        }
        return templateBundles;
    }

    protected Map<Long, List<ServiceReference<Object>>> getServicesByBundleId() throws InvalidSyntaxException {
        LinkedHashMap<Long, List<ServiceReference<Object>>> servicesByBundleId = new LinkedHashMap<Long, List<ServiceReference<Object>>>();
        ServiceReference<?>[] allServices = this.bundleHelper.getAllServices();
        if (allServices != null) {
            for (ServiceReference<?> serviceReference : allServices) {
                long bundleId = serviceReference.getBundle().getBundleId();
                if (!servicesByBundleId.containsKey(bundleId)) {
                    servicesByBundleId.put(bundleId, new ArrayList());
                }
                ((List)servicesByBundleId.get(bundleId)).add(serviceReference);
            }
        }
        return servicesByBundleId;
    }

    @Attribute(value="canRestartFramework")
    protected boolean canRestartFramework() {
        return this.osgiConfiguration.getFrameworkRestartEnabled();
    }

    @Attribute(value="systemPackageCacheExists")
    protected boolean systemPackageCacheExists() {
        return this.getConfiguration().getSystemPackageCache().isFile();
    }

    @Attribute(value="repositoryStoreLocation")
    protected String getRepositoryStoreLocation() {
        return this.bundleHelper.getBundleRepositoryLocation();
    }

    protected void restartFramework(Framework framework) {
        try {
            framework.stop();
            framework.waitForStop(0L);
            framework.start();
        }
        catch (BundleException bundleException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

