/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.AbstractResponseHelper;
import com.github.dynamicextensionsalfresco.osgi.Configuration;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptSession;

class ResponseHelper
extends AbstractResponseHelper {
    ResponseHelper(WebScriptRequest request, WebScriptResponse response, Configuration configuration) {
        super(request, response, configuration);
    }

    public void setFlashVariable(String name, Object value) {
        this.request.getRuntime().getSession().setValue(name, value);
    }

    public void flashErrorMessage(String errorMessage, Exception exception) throws IOException {
        String acceptedResponseTypes = this.request.getHeader("Accept");
        if (acceptedResponseTypes != null && acceptedResponseTypes.startsWith("text/plain")) {
            this.response.setStatus(500);
            if (exception != null) {
                exception.printStackTrace(new PrintWriter(this.response.getWriter()));
            } else {
                this.response.getWriter().write(errorMessage);
            }
        } else {
            this.setFlashVariable("errorMessage", errorMessage);
        }
    }

    public void flashSuccessMessage(String successMessage) {
        this.setFlashVariable("successMessage", successMessage);
    }

    public <T> T getFlashVariable(String name) {
        WebScriptSession session = this.request.getRuntime().getSession();
        Object value = session.getValue(name);
        session.removeValue(name);
        return (T)value;
    }
}

