/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel;

import com.github.dynamicextensionsalfresco.controlpanel.BundleHelper;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateWebScript;
import com.github.dynamicextensionsalfresco.webscripts.WebScriptUriRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.stereotype.Component;

@Component
public class WebScriptHelper {
    @Autowired
    private BundleHelper bundleHelper;

    public Map<String, List<TemplateWebScript>> getWebScripts() {
        WebScriptUriRegistry registry = this.getApplicationContextBean(WebScriptUriRegistry.class);
        if (registry != null) {
            List webScripts = registry.getWebScripts();
            ArrayList<TemplateWebScript> templateWebScripts = new ArrayList<TemplateWebScript>(webScripts.size());
            for (WebScript webScript : webScripts) {
                templateWebScripts.add(new TemplateWebScript(webScript));
            }
            HashMap<String, List<TemplateWebScript>> byFamily = new HashMap<String, List<TemplateWebScript>>();
            for (TemplateWebScript templateWebScript : templateWebScripts) {
                Set<String> familys = templateWebScript.getFamilys();
                if (familys == null) {
                    familys = new HashSet<String>(Arrays.asList("no family"));
                }
                for (String family : familys) {
                    ArrayList<TemplateWebScript> familiyList = (ArrayList<TemplateWebScript>)byFamily.get(family);
                    if (familiyList == null) {
                        familiyList = new ArrayList<TemplateWebScript>();
                        byFamily.put(family, familiyList);
                    }
                    familiyList.add(templateWebScript);
                }
            }
            return byFamily;
        }
        return Collections.emptyMap();
    }

    protected <T> T getApplicationContextBean(Class<T> clazz) {
        ApplicationContext applicationContext = this.bundleHelper.getService(ApplicationContext.class);
        if (applicationContext != null) {
            return (T)applicationContext.getBean(clazz);
        }
        return null;
    }
}

