/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel.template;

import com.github.dynamicextensionsalfresco.controlpanel.BundleHelper;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateImportedPackage;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateServiceReference;
import com.github.dynamicextensionsalfresco.osgi.BundleUtils;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.BundleManifestFactory;
import com.springsource.util.osgi.manifest.ExportedPackage;
import com.springsource.util.osgi.manifest.ImportedPackage;
import freemarker.template.utility.NullArgumentException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class TemplateBundle
implements Comparable<TemplateBundle> {
    private int FRAMEWORK_BUNDLE_ID = 0;
    private Bundle bundle;
    private List<TemplateServiceReference> services = null;
    private BundleManifest manifestCache = null;

    public TemplateBundle(Bundle bundle) {
        this(bundle, null);
    }

    public TemplateBundle(Bundle bundle, List<ServiceReference<Object>> services) {
        if (bundle == null) {
            throw new NullArgumentException("bundle");
        }
        this.bundle = bundle;
        this.init(services);
    }

    public List<TemplateServiceReference> getServices() {
        return this.services;
    }

    private void init(List<ServiceReference<Object>> initServices) {
        if (initServices == null) {
            this.services = Collections.emptyList();
            return;
        }
        this.services = initServices.stream().map(TemplateServiceReference::new).sorted().collect(Collectors.toList());
    }

    public Long getBundleId() {
        return this.bundle.getBundleId();
    }

    public String getSymbolicName() {
        return this.bundle.getSymbolicName() != null ? this.bundle.getSymbolicName() : "non OSGi jar file";
    }

    public String getName() {
        return this.getHeader("Bundle-Name") != null ? this.getHeader("Bundle-Name") : this.getSymbolicName();
    }

    public String getDescription() {
        return this.getHeader("Bundle-Description");
    }

    private String getHeader(String header) {
        return this.bundle.getHeaders() != null ? (String)this.bundle.getHeaders().get(header) : null;
    }

    public Boolean getDynamicExtension() {
        return BundleHelper.BundleHelperCompanion.isDynamicExtension(this.bundle);
    }

    public Boolean getFragmentBundle() {
        return this.getHeader("Fragment-Host") != null;
    }

    public String getLocation() {
        return this.bundle.getLocation();
    }

    public String getLastModified() {
        long lastModified = this.bundle.getLastModified();
        if (lastModified > 0L) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").format(new Date(lastModified));
        }
        return null;
    }

    public String getVersion() {
        return this.bundle.getVersion().toString();
    }

    public String getStore() {
        String defaultStore = "n/a";
        if (this.bundle.getLocation().startsWith("file:")) {
            return "filesystem";
        }
        if (this.bundle.getLocation().startsWith("/")) {
            return "repository";
        }
        return defaultStore;
    }

    public String getStatus() {
        return BundleUtils.getBundleStateDescription((int)this.bundle.getState());
    }

    public String getExportPackage() {
        return this.getHeader("Export-Package");
    }

    public String getDocumentationUrl() {
        return this.getHeader("Bundle-DocURL");
    }

    public Boolean getDeleteable() {
        return this.getLocation().startsWith("/Company Home");
    }

    public List<TemplateImportedPackage> getImportedPackages() {
        ArrayList<TemplateImportedPackage> packages = new ArrayList<TemplateImportedPackage>();
        BundleManifest manifest = this.getManifest();
        for (ImportedPackage importedPackage : manifest.getImportPackage().getImportedPackages()) {
            Version floor;
            TemplateImportedPackage bundlePackage = new TemplateImportedPackage();
            bundlePackage.setName(importedPackage.getPackageName());
            Version ceiling = importedPackage.getVersion().getCeiling();
            if (ceiling != null) {
                bundlePackage.setMaxVersion(ceiling.toString());
            }
            if ((floor = importedPackage.getVersion().getFloor()) != null) {
                bundlePackage.setMinVersion(floor.toString());
            }
            packages.add(bundlePackage);
        }
        return packages;
    }

    public List<ExportedPackage> getExportedPackages() {
        return this.getManifest() != null ? this.getManifest().getExportPackage().getExportedPackages() : new ArrayList();
    }

    public BundleManifest getManifest() {
        if (this.manifestCache == null) {
            this.manifestCache = BundleManifestFactory.createBundleManifest((Dictionary)this.bundle.getHeaders());
        }
        return this.manifestCache;
    }

    @Override
    public int compareTo(TemplateBundle other) {
        if (other == null) {
            return -1;
        }
        if (this.getBundleId().equals(this.FRAMEWORK_BUNDLE_ID)) {
            return Integer.MIN_VALUE;
        }
        if (other.getBundleId().equals(this.FRAMEWORK_BUNDLE_ID)) {
            return Integer.MAX_VALUE;
        }
        int compare = this.getName().compareToIgnoreCase(other.getName());
        if (compare == 0) {
            return this.getVersion().compareTo(other.getVersion());
        }
        return compare;
    }
}

