/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.controlpanel.template;

import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateBundle;
import com.github.dynamicextensionsalfresco.controlpanel.template.TemplateServiceReferenceProperties;
import java.util.Arrays;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class TemplateServiceReference
implements Comparable<TemplateServiceReference> {
    private static final String SERVICE_TYPE_PROPERTY = "alfresco.service.type";
    private static final String BEAN_NAME_PROPERTY = "osgi.service.blueprint.compname";
    private final ServiceReference serviceReference;

    public TemplateServiceReference(ServiceReference serviceReference) {
        Assert.notNull((Object)serviceReference);
        this.serviceReference = serviceReference;
    }

    public TemplateBundle getBundle() {
        return new TemplateBundle(this.serviceReference.getBundle());
    }

    public String[] getObjectClasses() {
        return (String[])this.serviceReference.getProperty("objectClass");
    }

    public String getBeanName() {
        return (String)this.serviceReference.getProperty(BEAN_NAME_PROPERTY);
    }

    public String getType() {
        return (String)this.serviceReference.getProperty(SERVICE_TYPE_PROPERTY);
    }

    public boolean isSpringContext() {
        return Arrays.asList(this.getObjectClasses()).contains(ApplicationContext.class.getName());
    }

    public String getServiceId() {
        return this.serviceReference.toString();
    }

    public List<String> getPropertyKeys() {
        return Arrays.asList(this.serviceReference.getPropertyKeys());
    }

    public TemplateServiceReferenceProperties getProperties() {
        return new TemplateServiceReferenceProperties(this.serviceReference);
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    @Override
    public int compareTo(TemplateServiceReference other) {
        String name2;
        int compare = 0;
        String name1 = this.getObjectClasses()[0];
        compare = name1.compareTo(name2 = other.getObjectClasses()[0]);
        if (compare == 0) {
            String type2;
            String type1 = this.getType();
            if (type1 == null) {
                type1 = "";
            }
            if ((type2 = other.getType()) == null) {
                type2 = "";
            }
            compare = type1.compareTo(type2);
        }
        return compare;
    }
}

