/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts;

import java.util.Collections;
import java.util.Map;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.util.Assert;

public class UrlModel {
    private final WebScriptRequest request;

    public UrlModel(WebScriptRequest request) {
        Assert.notNull((Object)request);
        this.request = request;
    }

    public String getServer() {
        return this.request.getServerPath();
    }

    public String getContext() {
        return this.request.getContextPath();
    }

    public String getServiceContext() {
        return this.request.getServiceContextPath();
    }

    public String getService() {
        return this.request.getServicePath();
    }

    public String getFull() {
        return this.request.getURL();
    }

    public String getArgs() {
        String args = this.request.getQueryString();
        return args == null ? "" : args;
    }

    public String getMatch() {
        return this.request.getServiceMatch().getPath();
    }

    public String getExtension() {
        return this.request.getExtensionPath();
    }

    public String getTemplate() {
        return this.request.getServiceMatch().getTemplate();
    }

    public Map<String, String> getTemplateArgs() {
        Map args = this.request.getServiceMatch().getTemplateVars();
        return args == null ? Collections.emptyMap() : args;
    }
}

