/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.resolutions;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebscriptResponse;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.Resolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.ResolutionParameters;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.StringUtils;

public abstract class AbstractResolution
implements Resolution {
    private AnnotationWebScriptRequest request;
    private AnnotationWebscriptResponse response;
    private ResolutionParameters params;
    private String encoding;
    private String contentType;
    private int statusCode = 200;

    @Override
    public void resolve(@Nonnull AnnotationWebScriptRequest request, @Nonnull AnnotationWebscriptResponse response, @Nonnull ResolutionParameters params) throws Exception {
        this.request = request;
        this.response = response;
        this.params = params;
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        if (this.encoding != null) {
            response.setContentEncoding(this.encoding);
        }
        if (this.statusCode != 200) {
            response.setStatus(this.statusCode);
        }
        this.resolve();
    }

    public AbstractResolution withContentType(@Nonnull String contentType) {
        this.contentType = contentType;
        return this;
    }

    public AbstractResolution withEncoding(@Nonnull String encoding) {
        this.encoding = encoding;
        return this;
    }

    public AbstractResolution withHeader(@Nonnull String headerName, @Nonnull String headerValue) {
        this.getResponse().setHeader(headerName, headerValue);
        return this;
    }

    public AbstractResolution withStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    protected void addCacheControlHeaders(WebScriptResponse response, ResolutionParameters params) {
        Description.RequiredCache requiredCache = params.getDescription().getRequiredCache();
        if (requiredCache != null) {
            ArrayList<String> cacheValues = new ArrayList<String>(3);
            if (requiredCache.getNeverCache()) {
                cacheValues.add("no-cache");
                cacheValues.add("no-store");
            }
            if (requiredCache.getMustRevalidate()) {
                cacheValues.add("must-revalidate");
            }
            if (!cacheValues.isEmpty()) {
                response.setHeader("Cache-Control", StringUtils.collectionToDelimitedString(cacheValues, (String)", "));
            }
        }
    }

    protected AnnotationWebScriptRequest getRequest() {
        return this.request;
    }

    protected AnnotationWebscriptResponse getResponse() {
        return this.response;
    }

    protected Writer getWriter() throws IOException {
        return this.getResponse().getWriter();
    }

    protected ResolutionParameters getParams() {
        return this.params;
    }

    public abstract void resolve() throws Exception;
}

