/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.resolutions;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebscriptResponse;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.Resolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.ResolutionParameters;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.springframework.util.Assert;

public class RedirectResolution
implements Resolution {
    private String path;

    public RedirectResolution(String path) {
        this.path = path;
    }

    @Override
    public void resolve(@Nonnull AnnotationWebScriptRequest request, @Nonnull AnnotationWebscriptResponse response, @Nonnull ResolutionParameters params) throws IOException {
        Assert.hasText((String)this.path);
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
        response.setStatus(302);
        response.setHeader("Location", request.getServiceContextPath() + this.path);
    }

    public String getPath() {
        return this.path;
    }
}

