/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.resolutions;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebscriptResponse;
import com.github.dynamicextensionsalfresco.webscripts.UrlModel;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.AbstractResolution;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.ResolutionParameters;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.TemplateProcessorRegistry;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TemplateResolution
extends AbstractResolution {
    private static final String URL_VARIABLE = "url";
    private static final String WEBSCRIPT_VARIABLE = "webscript";
    private static final String JSON_UTILS = "jsonUtils";
    private String template;
    private Map<String, Object> model;

    public TemplateResolution() {
        this.model = new HashMap<String, Object>(3);
    }

    public TemplateResolution(Map<String, Object> model) {
        this.model = model;
    }

    public TemplateResolution(String template, Map<String, Object> model) {
        this.template = template;
        this.model = model;
    }

    public TemplateResolution(String template) {
        this.template = template;
    }

    @Override
    public void resolve() throws Exception {
        AnnotationWebScriptRequest request = this.getRequest();
        AnnotationWebscriptResponse response = this.getResponse();
        ResolutionParameters params = this.getParams();
        if (!StringUtils.hasText((String)request.getFormat())) {
            response.setStatus(400);
            response.getWriter().write("No format specified.");
            return;
        }
        this.populateTemplateModel(this.model, request, params);
        int status = response.getStatus() != null ? response.getStatus() : 200;
        this.processTemplate((WebScriptRequest)request, this.model, status, (WebScriptResponse)response, params);
    }

    protected void populateTemplateModel(Map<String, Object> model, AnnotationWebScriptRequest request, ResolutionParameters params) {
        if (params != null) {
            model.put(WEBSCRIPT_VARIABLE, params.getDescription());
        }
        model.put(URL_VARIABLE, new UrlModel((WebScriptRequest)request));
        model.put(JSON_UTILS, new JSONUtils());
    }

    protected TemplateProcessor getTemplateProcessor(WebScriptRequest request) {
        TemplateProcessorRegistry templateProcessorRegistry = request.getRuntime().getContainer().getTemplateProcessorRegistry();
        return templateProcessorRegistry.getTemplateProcessorByExtension("ftl");
    }

    protected String generateTemplateName(TemplateProcessor templateProcessor, String format, int status, ResolutionParameters parameters) {
        Class<?> handlerClass = parameters.getHandlerClass();
        String methodName = parameters.getUriMethod().getName();
        String httpMethod = parameters.getDescription().getMethod().toLowerCase();
        String baseTemplateName = String.format("%s.%s.%s", ClassUtils.getQualifiedName(handlerClass).replace('.', '/'), methodName, httpMethod);
        String defaultTemplateName = String.format("%s.%s.ftl", baseTemplateName, format.toLowerCase());
        String templateName = String.format("%s.%s.%d.ftl", baseTemplateName, format.toLowerCase(), status);
        if (!templateProcessor.hasTemplate(templateName)) {
            String packageName = handlerClass.getPackage().getName().replace('.', '/');
            templateName = String.format("%s/%s.%d.ftl", packageName, format.toLowerCase(), status);
        }
        if (!templateProcessor.hasTemplate(templateName)) {
            templateName = String.format("%s.%d.ftl", format, status);
        }
        if (!templateProcessor.hasTemplate(templateName)) {
            templateName = defaultTemplateName;
        }
        return templateName;
    }

    protected void processTemplate(WebScriptRequest request, Map<String, Object> model, int status, WebScriptResponse response, ResolutionParameters params) throws IOException {
        TemplateProcessor templateProcessor = this.getTemplateProcessor(request);
        String format = request.getFormat();
        String templateName = this.getTemplate();
        if (!StringUtils.hasText((String)templateName)) {
            templateName = this.generateTemplateName(templateProcessor, format, status, params);
        }
        if (templateProcessor.hasTemplate(templateName)) {
            response.setContentType(Format.valueOf((String)format.toUpperCase()).mimetype());
            response.setContentEncoding("utf-8");
            if (params != null) {
                this.addCacheControlHeaders(response, params);
            }
            templateProcessor.process(templateName, model, response.getWriter());
        } else {
            response.setStatus(404);
            response.getWriter().write(String.format("Could not find template: %s", templateName));
        }
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    public void setModel(Map<String, Object> model) {
        this.model = model;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }
}

