/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.webscripts.support;

import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebScriptRequest;
import com.github.dynamicextensionsalfresco.webscripts.AnnotationWebscriptResponse;
import com.github.dynamicextensionsalfresco.webscripts.resolutions.TemplateResolution;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.util.HtmlUtils;

public abstract class AbstractBundleResourceHandler {
    @Autowired
    private BundleContext bundleContext;
    private Map<String, String> contentTypesByExtension;
    private String defaultContentType = "application/octet-stream";

    protected final void handleResource(String path, WebScriptResponse response) throws IOException {
        try {
            this.handleResource(path, null, response);
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final void handleResource(String path, WebScriptRequest request, WebScriptResponse response) throws Exception {
        String entryPath = this.getBundleEntryPath(path.replace("//", "/"));
        URL resource = this.getBundleContext().getBundle().getEntry(entryPath);
        if (resource != null) {
            if (resource.getPath().endsWith("/") && request != null) {
                this.sendDirectoryListing(request, response, resource);
            } else {
                this.sendResource(request, response, resource);
            }
        } else {
            this.handleResourceNotFound(path, response);
        }
    }

    protected void sendResource(WebScriptResponse response, URL resource) throws IOException {
        this.sendResource(null, response, resource);
    }

    protected void sendResource(WebScriptRequest request, WebScriptResponse response, URL resource) throws IOException {
        String contentType = this.getContentType(resource);
        response.setContentType(contentType);
        response.setContentEncoding(this.getContentEncoding(resource));
        URLConnection connection = resource.openConnection();
        long lastModified = this.getBundleContext().getBundle().getLastModified();
        response.setHeader("Last-Modified", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH).format(new Date(lastModified)));
        int contentLength = connection.getContentLength();
        if (contentLength > -1) {
            response.setHeader("Content-Length", String.valueOf(contentLength));
        }
        FileCopyUtils.copy((InputStream)connection.getInputStream(), (OutputStream)response.getOutputStream());
    }

    protected void sendDirectoryListing(WebScriptRequest request, WebScriptResponse response, URL resource) throws Exception {
        Enumeration entries = this.getBundleContext().getBundle().getEntryPaths(resource.getPath());
        ArrayList<String> paths = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            if (entry.endsWith("/")) {
                paths.add(entry.substring(entry.lastIndexOf(47, entry.length() - 2) + 1));
                continue;
            }
            paths.add(entry.substring(entry.lastIndexOf(47) + 1));
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("paths", paths);
        TemplateResolution resolution = new TemplateResolution("dynamicextensionsalfresco/directory-listing.html.ftl", model);
        resolution.resolve(new AnnotationWebScriptRequest(request), new AnnotationWebscriptResponse(response), null);
    }

    protected void handleResourceNotFound(String path, WebScriptResponse response) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        Writer out = response.getWriter();
        out.write(String.format("<!doctype html><head><title>Not found</title></head><body>Could not find resource at path '%s'.</body></html>", HtmlUtils.htmlEscape((String)path)));
        out.close();
    }

    protected String getBundleEntryPath(String path) {
        return path;
    }

    protected String getContentType(URL resource) {
        Matcher matcher = Pattern.compile(".+\\.(\\w+)$").matcher(resource.getFile());
        String extension = matcher.matches() ? matcher.group(1) : null;
        String contentType = null;
        if (extension != null) {
            contentType = this.getContentTypesByExtension().get(extension.toLowerCase());
        }
        if (contentType == null) {
            contentType = this.getDefaultContentType();
        }
        return contentType;
    }

    protected void setInfinateCache(WebScriptResponse response) {
        long future = new Date().getTime() + 31536000000L;
        response.setHeader("Expires", new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z").format(new Date(future)));
        response.setHeader("Cache-Control", "max-age=" + future);
    }

    @PostConstruct
    protected void initContentTypes() {
        if (this.contentTypesByExtension != null) {
            return;
        }
        this.contentTypesByExtension = new HashMap<String, String>();
        this.contentTypesByExtension.put("js", "text/javascript");
        this.contentTypesByExtension.put("map", "application/json");
        this.contentTypesByExtension.put("css", "text/css");
        this.contentTypesByExtension.put("json", "application/json");
        this.contentTypesByExtension.put("gif", "image/gif");
        this.contentTypesByExtension.put("png", "image/png");
        this.contentTypesByExtension.put("jpg", "image/jpeg");
        this.contentTypesByExtension.put("svg", "image/svg+xml");
        this.contentTypesByExtension.put("html", "text/html");
    }

    protected String getContentEncoding(URL resource) {
        return "utf-8";
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setContentTypesByExtension(Map<String, String> contentTypesByExtension) {
        Assert.notEmpty(contentTypesByExtension);
        this.contentTypesByExtension = contentTypesByExtension;
    }

    protected Map<String, String> getContentTypesByExtension() {
        return this.contentTypesByExtension;
    }

    public void setDefaultContentType(String defaultContentType) {
        Assert.hasText((String)defaultContentType);
        this.defaultContentType = defaultContentType;
    }

    protected String getDefaultContentType() {
        return this.defaultContentType;
    }
}

