/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco;

import com.github.dynamicextensionsalfresco.QNamePropertyEditor;
import java.lang.annotation.Annotation;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractAnnotationBasedRegistrar
implements BeanFactoryAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConfigurableListableBeanFactory beanFactory;
    private NamespacePrefixResolver namespacePrefixResolver;

    protected QName[] parseQNames(String[] values, Annotation annotation) {
        QName[] qNames = new QName[values.length];
        for (int i = 0; i < values.length; ++i) {
            qNames[i] = this.parseQName(values[i], annotation);
        }
        return qNames;
    }

    protected QName parseQName(String value, Annotation annotation) {
        QName qName;
        block2: {
            qName = null;
            try {
                QNamePropertyEditor editor = new QNamePropertyEditor(this.getNamespacePrefixResolver());
                editor.setAsText(value);
                qName = (QName)editor.getValue();
            }
            catch (RuntimeException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Invalid QName specified on annotation {}: {}", (Object)annotation, (Object)e.getMessage());
            }
        }
        return qName;
    }

    protected static String nullForEmptyString(String value) {
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"BeanFactory is not of type ConfigurableListableBeanFactory.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }
}

