/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco;

import java.beans.PropertyEditorSupport;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.util.StringUtils;

class QNamePropertyEditor
extends PropertyEditorSupport {
    private final String PREFIX_FORMAT_PATTERN = ".+?:.+?";
    private final String FULLY_QUALIFIED_FORMAT_PATTERN = "\\{.+?\\}.+?";
    private NamespacePrefixResolver namespacePrefixResolver;

    public QNamePropertyEditor(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public QNamePropertyEditor() {
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else if (text.matches(".+?:.+?")) {
            this.setValue(QName.createQName((String)text, (NamespacePrefixResolver)this.getNamespacePrefixResolver()));
        } else if (text.matches("\\{.+?\\}.+?")) {
            this.setValue(QName.createQName((String)text));
        } else {
            throw new IllegalArgumentException("Invalid value: " + text);
        }
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    protected NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }
}

