/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.actions;

import com.github.dynamicextensionsalfresco.AbstractAnnotationBasedRegistrar;
import com.github.dynamicextensionsalfresco.actions.ActionExecuterRegistry;
import com.github.dynamicextensionsalfresco.actions.ActionMethodMapping;
import com.github.dynamicextensionsalfresco.actions.AnnotationBasedActionExecuter;
import com.github.dynamicextensionsalfresco.actions.ApiCompatibilityUtil;
import com.github.dynamicextensionsalfresco.actions.DummyActionExecutor;
import com.github.dynamicextensionsalfresco.actions.ParameterMapping;
import com.github.dynamicextensionsalfresco.actions.annotations.ActionMethod;
import com.github.dynamicextensionsalfresco.actions.annotations.ActionParam;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.repo.action.ActionDefinitionImpl;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationBasedActionRegistrar
extends AbstractAnnotationBasedRegistrar {
    public static final String SET_LOCALIZED_PARAMETER_DEFINITIONS = "setLocalizedParameterDefinitions";
    private DictionaryService dictionaryService;
    private ActionExecuterRegistry actionExecuterRegistry;
    private RuntimeActionService runtimeActionService;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final Map<Class<?>, QName> parameterTypes = this.getActionParameterMapping();
    private final List<ActionExecuter> registeredActionExecutors = new ArrayList<ActionExecuter>();

    public void registerAnnotationBasedActions() {
        final ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        for (final String beanName : beanFactory.getBeanDefinitionNames()) {
            Class type = beanFactory.getType(beanName);
            if (type == null) continue;
            ReflectionUtils.doWithMethods((Class)type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    ActionMethod actionMethod = (ActionMethod)AnnotationUtils.findAnnotation((Method)method, ActionMethod.class);
                    if (actionMethod != null) {
                        ActionExecuter actionExecuter = AnnotationBasedActionRegistrar.this.createActionExecuter(beanFactory.getBean(beanName), method, actionMethod);
                        ActionDefinition actionDefinition = actionExecuter.getActionDefinition();
                        String name = actionDefinition.getName();
                        if (!AnnotationBasedActionRegistrar.this.getActionExecuterRegistry().hasActionExecuter(name)) {
                            if (AnnotationBasedActionRegistrar.this.logger.isDebugEnabled()) {
                                AnnotationBasedActionRegistrar.this.logger.debug("Registering ActionExecuter {}.", (Object)name);
                            }
                            AnnotationBasedActionRegistrar.this.getActionExecuterRegistry().registerActionExecuter(actionExecuter);
                            AnnotationBasedActionRegistrar.this.registeredActionExecutors.add(actionExecuter);
                            AnnotationBasedActionRegistrar.this.registerActionToken(actionDefinition);
                        } else if (AnnotationBasedActionRegistrar.this.logger.isWarnEnabled()) {
                            AnnotationBasedActionRegistrar.this.logger.warn("ActionExecuter name has already been registered.");
                        }
                    }
                }
            });
        }
    }

    private synchronized void registerActionToken(ActionDefinition actionDefinition) {
        this.runtimeActionService.registerActionExecuter((ActionExecuter)new DummyActionExecutor(actionDefinition));
    }

    public void unregisterAnnotationBasedActions() {
        for (ActionExecuter actionExecuter : this.registeredActionExecutors) {
            this.logger.debug("Unregistering ActionExecuter {}.", (Object)actionExecuter.getActionDefinition().getName());
            this.getActionExecuterRegistry().unregisterActionExecuter(actionExecuter);
        }
    }

    protected ActionExecuter createActionExecuter(Object bean, Method method, ActionMethod actionMethod) {
        ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
        ActionMethodMapping mapping = this.resolveActionMethodMapping(bean, method, parameterDefinitions);
        return new AnnotationBasedActionExecuter(this.createActionDefinition(method, actionMethod, parameterDefinitions), mapping, AnnotationBasedActionRegistrar.nullForEmptyString(actionMethod.queueName()));
    }

    protected ActionDefinition createActionDefinition(Method method, ActionMethod actionMethod, List<ParameterDefinition> parameterDefinitions) {
        String name = actionMethod.value();
        if (StringUtils.isEmpty((Object)name)) {
            name = String.format("%s.%s", ClassUtils.getShortName(method.getDeclaringClass()), method.getName());
        }
        ActionDefinitionImpl actionDefinition = new ActionDefinitionImpl(name);
        Class<?> actionDefinitionClass = actionDefinition.getClass();
        List<Method> methodList = Arrays.asList(actionDefinitionClass.getMethods());
        Method setLocalizedParameterDefinitions = null;
        for (Method m : methodList) {
            if (!m.getName().equals(SET_LOCALIZED_PARAMETER_DEFINITIONS)) continue;
            setLocalizedParameterDefinitions = m;
            break;
        }
        if (setLocalizedParameterDefinitions != null) {
            try {
                HashMap<Locale, List<ParameterDefinition>> localizedParameterDefinitions = new HashMap<Locale, List<ParameterDefinition>>(2);
                localizedParameterDefinitions.put(Locale.ROOT, parameterDefinitions);
                setLocalizedParameterDefinitions.invoke((Object)actionDefinition, localizedParameterDefinitions);
            }
            catch (Exception e) {
                this.logger.error("Could not set fallback localized parameter list", (Throwable)e);
                actionDefinition.setParameterDefinitions(parameterDefinitions);
            }
        } else {
            actionDefinition.setParameterDefinitions(parameterDefinitions);
        }
        actionDefinition.setAdhocPropertiesAllowed(actionMethod.adhocPropertiesAllowed());
        ApiCompatibilityUtil.setApplicableTypes(actionDefinition, Arrays.asList(this.parseQNames(actionMethod.applicableTypes(), (Annotation)actionMethod)));
        actionDefinition.setTitleKey(AnnotationBasedActionRegistrar.nullForEmptyString(actionMethod.titleKey()));
        actionDefinition.setDescriptionKey(AnnotationBasedActionRegistrar.nullForEmptyString(actionMethod.descriptionKey()));
        actionDefinition.setRuleActionExecutor(AnnotationBasedActionRegistrar.nullForEmptyString(actionMethod.ruleActionExecutor()));
        return actionDefinition;
    }

    protected ActionMethodMapping resolveActionMethodMapping(Object bean, Method method, List<ParameterDefinition> parameterDefinitions) {
        ActionMethodMapping mapping = new ActionMethodMapping(bean, method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] parameterTypes = method.getGenericParameterTypes();
        String[] methodParameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        for (int index = 0; index < parameterTypes.length; ++index) {
            Type parameterType = parameterTypes[index];
            Class<?> clazz = null;
            boolean multivalued = false;
            if (parameterType instanceof Class) {
                clazz = (Class<?>)parameterType;
            } else if (AnnotationBasedActionRegistrar.isCollectionType(parameterType)) {
                multivalued = true;
                clazz = this.getCollectionType((ParameterizedType)parameterType);
            }
            if (clazz == null) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Cannot handle Parameter type {}.", (Object)parameterType);
                continue;
            }
            if (!multivalued) {
                if (NodeRef.class.isAssignableFrom(clazz)) {
                    boolean hasParameterAnnotation = false;
                    Annotation[] annotationArray = parameterAnnotations[index];
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation parameterAnnotation = annotationArray[i];
                        if (!(parameterAnnotation instanceof ActionParam)) continue;
                        hasParameterAnnotation = true;
                        break;
                    }
                    if (!hasParameterAnnotation) {
                        if (mapping.getNodeRefParameterIndex() < 0) {
                            mapping.setNodeRefParameterIndex(index);
                        } else if (this.logger.isWarnEnabled()) {
                            this.logger.warn("NodeRef parameter has already been set. Duplicate NodeRef parameters without an @ActionParam will be ignored.");
                        }
                    }
                } else if (Action.class.isAssignableFrom(clazz)) {
                    if (mapping.getActionParameterIndex() < 0) {
                        mapping.setActionParameterIndex(index);
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Action parameter has already been configured. Duplicate Action parameters will be ignored.");
                    }
                }
            }
            for (Annotation parameterAnnotation : parameterAnnotations[index]) {
                if (!(parameterAnnotation instanceof ActionParam)) continue;
                ActionParam actionParameter = (ActionParam)parameterAnnotation;
                String name = actionParameter.value();
                if (StringUtils.isEmpty((Object)name)) {
                    name = methodParameterNames[index];
                }
                if (StringUtils.isEmpty((Object)name)) {
                    throw new RuntimeException(String.format("Cannot determine name of parameter at index %s of method %s. No name specified in @RequestParam annotation and no name available in debug info.", index, method));
                }
                DataTypeDefinition dataType = this.getDataType(clazz, actionParameter);
                if (dataType == null) {
                    throw new RuntimeException(String.format("Cannot map parameter of type %s for action method %s. Make sure you specify a valid DataType from the Dictionary.", clazz, method));
                }
                boolean mandatory = actionParameter.mandatory();
                String displayLabel = actionParameter.displayLabel();
                String trimmedConstraintName = StringUtils.trimWhitespace((String)actionParameter.constraintName());
                String constraintName = trimmedConstraintName.isEmpty() ? null : trimmedConstraintName;
                ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(name, dataType.getName(), mandatory, displayLabel, multivalued, constraintName);
                parameterDefinitions.add((ParameterDefinition)parameterDefinition);
                String parameterName = parameterDefinition.getName();
                if (!mapping.hasParameter(parameterName)) {
                    mapping.addParameterMapping(new ParameterMapping((ParameterDefinition)parameterDefinition, index));
                    continue;
                }
                throw new RuntimeException(String.format("Duplicate parameter '%s'", parameterName));
            }
        }
        return mapping;
    }

    private DataTypeDefinition getDataType(Class<?> clazz, ActionParam actionParameter) {
        DataTypeDefinition dataType;
        if (!StringUtils.isEmpty((Object)actionParameter.type())) {
            dataType = this.getDictionaryService().getDataType(this.parseQName(actionParameter.type(), (Annotation)actionParameter));
            if (dataType == null) {
                throw new RuntimeException(String.format("Invalid or unknown DataType: %s", actionParameter.type()));
            }
        } else {
            QName qName = this.parameterTypes.get(clazz);
            if (qName == null) {
                throw new RuntimeException(String.format("%s is not a standard parameter type, specify the type explicitly", clazz));
            }
            dataType = this.getDictionaryService().getDataType(qName);
        }
        return dataType;
    }

    private static boolean isCollectionType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return rawType instanceof Class && Collection.class.isAssignableFrom((Class)rawType);
        }
        return false;
    }

    private Class<?> getCollectionType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (rawType instanceof Class && Collection.class.isAssignableFrom((Class)rawType) && actualTypeArguments.length == 1 && actualTypeArguments[0] instanceof Class) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    protected Map<Class<?>, QName> getActionParameterMapping() {
        return ImmutableMap.builder().put(String.class, (Object)DataTypeDefinition.TEXT).put(Long.class, (Object)DataTypeDefinition.LONG).put(Double.class, (Object)DataTypeDefinition.DOUBLE).put(Date.class, (Object)DataTypeDefinition.DATETIME).put(Boolean.class, (Object)DataTypeDefinition.BOOLEAN).put(NodeRef.class, (Object)DataTypeDefinition.NODE_REF).put(QName.class, (Object)DataTypeDefinition.QNAME).build();
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setActionExecuterRegistry(ActionExecuterRegistry actionExecuterRegistry) {
        this.actionExecuterRegistry = actionExecuterRegistry;
    }

    protected ActionExecuterRegistry getActionExecuterRegistry() {
        return this.actionExecuterRegistry;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }
}

