/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.actions;

import com.github.dynamicextensionsalfresco.actions.ActionExecuterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultActionExecuterRegistry
implements ActionExecuterRegistry,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Map<String, ActionExecuter> actionExecutersByName = new ConcurrentHashMap<String, ActionExecuter>();

    @Override
    public boolean hasActionExecuter(String name) {
        return this.actionExecutersByName.containsKey(name) || this.applicationContext.containsBeanDefinition(name);
    }

    @Override
    public ActionExecuter getActionExecuter(String name) {
        return this.actionExecutersByName.get(name);
    }

    @Override
    public void registerActionExecuter(ActionExecuter actionExecuter) {
        String name = actionExecuter.getActionDefinition().getName();
        if (this.hasActionExecuter(name)) {
            throw new IllegalStateException("Duplicate ActionExecuter " + name);
        }
        this.getActionExecutersByName().put(name, actionExecuter);
    }

    @Override
    public void unregisterActionExecuter(ActionExecuter actionExecuter) {
        if (this.getActionExecutersByName().containsValue(actionExecuter)) {
            this.actionExecutersByName.remove(actionExecuter.getActionDefinition().getName());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Map<String, ActionExecuter> getActionExecutersByName() {
        return this.actionExecutersByName;
    }
}

