/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.aop;

import com.github.dynamicextensionsalfresco.annotations.Transactional;
import java.lang.reflect.Method;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class TransactionalAdvice
implements MethodInterceptor {
    private RetryingTransactionHelper retryingTransactionHelper;

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Transactional transactional = (Transactional)AnnotationUtils.findAnnotation((Method)invocation.getMethod(), Transactional.class);
        return this.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                return invocation.proceed();
            }
        }, transactional.readOnly(), transactional.requiresNew());
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        Assert.notNull((Object)retryingTransactionHelper);
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    protected RetryingTransactionHelper getRetryingTransactionHelper() {
        return this.retryingTransactionHelper;
    }
}

