/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.metrics;

import com.github.dynamicextensionsalfresco.metrics.Timer;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StopWatch;

public final class SpringTimer
implements Timer {
    private final Logger logger = LoggerFactory.getLogger(SpringTimer.class);
    private final String identifier = SpringTimer.class.getPackage().getName();

    @Override
    public boolean isEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void start(String label) {
        if (this.isEnabled()) {
            StopWatch stopWatch = this.getStopWatch();
            if (stopWatch.isRunning()) {
                stopWatch.stop();
            }
            stopWatch.start(label);
        }
    }

    @Override
    public void stop() {
        StopWatch stopWatch;
        if (this.isEnabled() && (stopWatch = this.getStopWatch()).isRunning()) {
            stopWatch.stop();
        }
    }

    @NotNull
    private StopWatch getStopWatch() {
        Object stopWatch = TransactionSynchronizationManager.getResource((Object)this.identifier);
        if (!(stopWatch instanceof StopWatch)) {
            stopWatch = null;
        }
        if (stopWatch == null) {
            stopWatch = new StopWatch(this.identifier);
            TransactionSynchronizationManager.bindResource((Object)this.identifier, (Object)stopWatch);
            this.registerTxListener();
        }
        return (StopWatch)stopWatch;
    }

    private void registerTxListener() {
        AlfrescoTransactionSupport.bindListener((TransactionListener)new TransactionListener(){

            public void flush() {
            }

            public void beforeCommit(boolean readOnly) {
            }

            public void beforeCompletion() {
            }

            public void afterCommit() {
                SpringTimer.this.logger.trace(SpringTimer.this.getStopWatch().prettyPrint());
            }

            public void afterRollback() {
            }
        });
    }
}

