/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.policy;

import com.github.dynamicextensionsalfresco.AbstractAnnotationBasedRegistrar;
import com.github.dynamicextensionsalfresco.behaviours.annotations.AssociationPolicy;
import com.github.dynamicextensionsalfresco.behaviours.annotations.ClassPolicy;
import com.github.dynamicextensionsalfresco.behaviours.annotations.Event;
import com.github.dynamicextensionsalfresco.policy.DescriptiveJavaBehaviour;
import com.github.dynamicextensionsalfresco.util.EventUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyType;
import org.alfresco.repo.policy.PropertyPolicy;
import org.alfresco.service.namespace.QName;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationBasedBehaviourRegistrar
extends AbstractAnnotationBasedRegistrar {
    private PolicyComponent policyComponent;

    public void bindBehaviours() {
        for (String beanName : this.getBeanFactory().getBeanDefinitionNames()) {
            com.github.dynamicextensionsalfresco.behaviours.annotations.Behaviour behaviour = (com.github.dynamicextensionsalfresco.behaviours.annotations.Behaviour)this.getBeanFactory().findAnnotationOnBean(beanName, com.github.dynamicextensionsalfresco.behaviours.annotations.Behaviour.class);
            if (behaviour == null) continue;
            this.bindBehaviours(this.getBeanFactory().getBean(beanName), behaviour);
        }
    }

    protected void bindBehaviours(Object bean, com.github.dynamicextensionsalfresco.behaviours.annotations.Behaviour behaviour) {
        Assert.notNull((Object)bean, (String)"Bean cannot be null.");
        QName[] classNames = this.parseQNames(behaviour.value(), (Annotation)behaviour);
        Behaviour.NotificationFrequency notificationFrequency = EventUtil.toNotificationFrequency(behaviour.event());
        for (Map.Entry<PolicyType, List<BehaviourMethod>> entry : this.getBehaviourMethodsByType(bean.getClass()).entrySet()) {
            for (BehaviourMethod behaviourMethod : entry.getValue()) {
                switch (entry.getKey()) {
                    case Class: {
                        this.bindClassPolicyBehaviour(bean, behaviourMethod.method, behaviourMethod.policyName, classNames, notificationFrequency);
                        break;
                    }
                    case Association: {
                        this.bindAssocationPolicyBehaviour(bean, behaviourMethod.method, behaviourMethod.policyName, classNames, notificationFrequency);
                        break;
                    }
                    case Property: {
                        this.bindPropertyPolicyBehaviour(bean, behaviourMethod.method, behaviourMethod.policyName, classNames, notificationFrequency);
                    }
                }
            }
        }
    }

    protected void bindClassPolicyBehaviour(Object bean, Method method, QName policyName, QName[] classNames, Behaviour.NotificationFrequency notificationFrequency) {
        ClassPolicy classPolicy = (ClassPolicy)AnnotationUtils.findAnnotation((Method)method, ClassPolicy.class);
        if (classPolicy != null) {
            classNames = this.parseQNames(classPolicy.value(), (Annotation)classPolicy);
            if (!classPolicy.event().equals((Object)Event.INHERITED_OR_ALL)) {
                notificationFrequency = EventUtil.toNotificationFrequency(classPolicy.event());
            }
        }
        DescriptiveJavaBehaviour behaviour = new DescriptiveJavaBehaviour(bean, method, notificationFrequency);
        if (classNames.length > 0) {
            for (QName className : classNames) {
                if (className == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Binding class Behaviour for policy {} and class {} for method {} with notification frequency {}.", new Object[]{policyName, className, method, notificationFrequency});
                }
                this.getPolicyComponent().bindClassBehaviour(policyName, className, (Behaviour)behaviour);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Binding class Behaviour for policy {} for method {} with notification frequency {}.", new Object[]{policyName, method, notificationFrequency});
            }
            this.getPolicyComponent().bindClassBehaviour(policyName, bean, (Behaviour)behaviour);
        }
        this.warnAboutInapplicablePolicyAnnotations(method, AssociationPolicy.class, com.github.dynamicextensionsalfresco.behaviours.annotations.PropertyPolicy.class);
    }

    protected void bindAssocationPolicyBehaviour(Object bean, Method method, QName policyName, QName[] classNames, Behaviour.NotificationFrequency notificationFrequency) {
        AssociationPolicy associationPolicy = (AssociationPolicy)AnnotationUtils.findAnnotation((Method)method, AssociationPolicy.class);
        QName assocationName = null;
        if (associationPolicy != null) {
            String[] localClassNames = associationPolicy.value();
            if (localClassNames.length > 0) {
                classNames = this.parseQNames(localClassNames, (Annotation)associationPolicy);
            }
            assocationName = this.parseQName(associationPolicy.association(), (Annotation)associationPolicy);
            if (!associationPolicy.event().equals((Object)Event.INHERITED_OR_ALL)) {
                notificationFrequency = EventUtil.toNotificationFrequency(associationPolicy.event());
            }
        }
        DescriptiveJavaBehaviour behaviour = new DescriptiveJavaBehaviour(bean, method, notificationFrequency);
        if (classNames.length > 0) {
            for (QName className : classNames) {
                if (assocationName != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Binding association Behaviour for policy {}, class {} and association {} for method {} with notification frequency {}.", new Object[]{policyName, className, assocationName, method, notificationFrequency});
                    }
                    this.getPolicyComponent().bindAssociationBehaviour(policyName, className, assocationName, (Behaviour)behaviour);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Binding association Behaviour for policy {} and class {} for method {} with notification frequency {}.", new Object[]{policyName, className, method, notificationFrequency});
                }
                this.getPolicyComponent().bindAssociationBehaviour(policyName, className, (Behaviour)behaviour);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Binding association Behaviour for policy {} for method {} with notification frequency {}.", new Object[]{policyName, method, notificationFrequency});
            }
            this.getPolicyComponent().bindAssociationBehaviour(policyName, bean, (Behaviour)behaviour);
        }
        this.warnAboutInapplicablePolicyAnnotations(method, ClassPolicy.class, com.github.dynamicextensionsalfresco.behaviours.annotations.PropertyPolicy.class);
    }

    protected void bindPropertyPolicyBehaviour(Object bean, Method method, QName policyName, QName[] classNames, Behaviour.NotificationFrequency notificationFrequency) {
        com.github.dynamicextensionsalfresco.behaviours.annotations.PropertyPolicy propertyPolicy = (com.github.dynamicextensionsalfresco.behaviours.annotations.PropertyPolicy)AnnotationUtils.findAnnotation((Method)method, com.github.dynamicextensionsalfresco.behaviours.annotations.PropertyPolicy.class);
        QName propertyName = null;
        if (propertyPolicy != null) {
            if (propertyPolicy.value().length > 0) {
                classNames = this.parseQNames(propertyPolicy.value(), (Annotation)propertyPolicy);
            }
            propertyName = this.parseQName(propertyPolicy.property(), (Annotation)propertyPolicy);
            if (!propertyPolicy.event().equals((Object)Event.INHERITED_OR_ALL)) {
                notificationFrequency = EventUtil.toNotificationFrequency(propertyPolicy.event());
            }
        }
        DescriptiveJavaBehaviour behaviour = new DescriptiveJavaBehaviour(bean, method, notificationFrequency);
        if (classNames.length > 0) {
            for (QName className : classNames) {
                if (propertyName != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Binding property Behaviour for policy {}, class {} and property {} for method {} with notification frequency {}.", new Object[]{policyName, className, propertyName, method, notificationFrequency});
                    }
                    this.getPolicyComponent().bindPropertyBehaviour(policyName, className, propertyName, (Behaviour)behaviour);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Binding property Behaviour for policy {} and class {} for method {} with notification frequency {}.", new Object[]{policyName, className, method, notificationFrequency});
                }
                this.getPolicyComponent().bindPropertyBehaviour(policyName, className, (Behaviour)behaviour);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Binding property Behaviour for policy {} for method {} with notification frequency {}.", new Object[]{policyName, method, notificationFrequency});
            }
            this.getPolicyComponent().bindPropertyBehaviour(policyName, bean, (Behaviour)behaviour);
        }
        this.warnAboutInapplicablePolicyAnnotations(method, ClassPolicy.class, AssociationPolicy.class);
    }

    private QName getPolicyQName(Class<? extends Policy> policyClass) {
        QName qName = null;
        try {
            Field field = policyClass.getField("QNAME");
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && QName.class.isAssignableFrom(field.getType())) {
                qName = (QName)field.get(null);
            }
        }
        catch (NoSuchFieldException field) {
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return qName;
    }

    private void warnAboutInapplicablePolicyAnnotations(Method method, Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationClass);
            if (annotation == null || !this.logger.isWarnEnabled()) continue;
            this.logger.warn("Found {} annotation on method {}. This annotation is not applicable here and will be ignored.", (Object)annotation.annotationType().getName(), (Object)method);
        }
    }

    private Map<PolicyType, List<Class<? extends Policy>>> getPolicyInterfacesByType(Class<?> clazz) {
        HashMap<PolicyType, List<Class<? extends Policy>>> policyInterfacesByType = new HashMap<PolicyType, List<Class<? extends Policy>>>();
        for (Class interfaceClass : ClassUtils.getAllInterfacesForClassAsSet(clazz)) {
            PolicyType policyType = null;
            if (org.alfresco.repo.policy.ClassPolicy.class.isAssignableFrom(interfaceClass)) {
                policyType = PolicyType.Class;
            } else if (org.alfresco.repo.policy.AssociationPolicy.class.isAssignableFrom(interfaceClass)) {
                policyType = PolicyType.Association;
            } else if (PropertyPolicy.class.isAssignableFrom(interfaceClass)) {
                policyType = PolicyType.Property;
            }
            if (policyType == null) continue;
            if (!policyInterfacesByType.containsKey(policyType)) {
                policyInterfacesByType.put(policyType, new ArrayList());
            }
            ((List)policyInterfacesByType.get(policyType)).add(interfaceClass);
        }
        return policyInterfacesByType;
    }

    private Map<PolicyType, List<BehaviourMethod>> getBehaviourMethodsByType(Class<?> beanClass) {
        Map<PolicyType, List<Class<? extends Policy>>> policyInterfacesByType = this.getPolicyInterfacesByType(beanClass);
        HashMap<PolicyType, List<BehaviourMethod>> behaviourMethodsByType = new HashMap<PolicyType, List<BehaviourMethod>>();
        for (Map.Entry<PolicyType, List<Class<? extends Policy>>> entry : policyInterfacesByType.entrySet()) {
            ArrayList<BehaviourMethod> behaviourMethods = new ArrayList<BehaviourMethod>();
            for (Class<? extends Policy> policyInterface : entry.getValue()) {
                Method policyInterfaceMethod;
                Method behaviourMethod;
                if (policyInterface.getMethods().length != 1 || (behaviourMethod = ReflectionUtils.findMethod(beanClass, (String)(policyInterfaceMethod = policyInterface.getMethods()[0]).getName(), (Class[])policyInterfaceMethod.getParameterTypes())) == null) continue;
                behaviourMethods.add(new BehaviourMethod(this.getPolicyQName(policyInterface), behaviourMethod));
            }
            if (behaviourMethods.isEmpty()) continue;
            behaviourMethodsByType.put(entry.getKey(), behaviourMethods);
        }
        return behaviourMethodsByType;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    protected PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    private static class BehaviourMethod {
        final QName policyName;
        final Method method;

        private BehaviourMethod(QName policyName, Method method) {
            this.policyName = policyName;
            this.method = method;
        }
    }
}

