/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.policy;

import com.github.dynamicextensionsalfresco.metrics.Timer;
import com.github.dynamicextensionsalfresco.policy.NoOpBehaviour;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.service.cmr.repository.NodeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BehaviourProxy
implements Behaviour {
    private final ConcurrentHashMap<Class<?>, ProxyPolicy> proxiesByPolicyClass;
    private Behaviour behaviour;
    @NotNull
    private final Timer timer;

    public BehaviourProxy(@NotNull Behaviour behaviour, @NotNull Timer timer) {
        if (behaviour == null) {
            throw new IllegalArgumentException("behaviour is null");
        }
        if (timer == null) {
            throw new IllegalArgumentException("timer is null");
        }
        this.behaviour = behaviour;
        this.timer = timer;
        this.proxiesByPolicyClass = new ConcurrentHashMap();
    }

    public <T> T getInterface(@Nullable Class<T> policy) {
        if (policy == null) {
            return null;
        }
        ProxyPolicy proxyPolicy = this.proxiesByPolicyClass.get(policy);
        if (proxyPolicy == null) {
            if (this.behaviour instanceof NoOpBehaviour) {
                ProxyPolicyInvocationHandler proxyHandler = new ProxyPolicyInvocationHandler(null, this.behaviour, this.timer);
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{policy}, (InvocationHandler)proxyHandler);
                proxyPolicy = new ProxyPolicy(proxy, proxyHandler);
            } else {
                Object originalHandler = this.behaviour.getInterface(policy);
                ProxyPolicyInvocationHandler proxyHandler = new ProxyPolicyInvocationHandler(originalHandler, this.behaviour, this.timer);
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{policy}, (InvocationHandler)proxyHandler);
                proxyPolicy = new ProxyPolicy(proxy, proxyHandler);
            }
            this.proxiesByPolicyClass.put(policy, proxyPolicy);
        }
        return (T)proxyPolicy.getProxy();
    }

    public final synchronized void release() {
        this.behaviour = new NoOpBehaviour(this.behaviour.getNotificationFrequency(), this.behaviour.isEnabled());
        for (ProxyPolicy proxyPolicy : this.proxiesByPolicyClass.values()) {
            proxyPolicy.handler.release();
        }
    }

    @NotNull
    public String toString() {
        return this.behaviour.toString();
    }

    @NotNull
    public final Timer getTimer() {
        return this.timer;
    }

    public void disable() {
        this.behaviour.disable();
    }

    public void enable() {
        this.behaviour.enable();
    }

    public boolean isEnabled() {
        return this.behaviour.isEnabled();
    }

    public Behaviour.NotificationFrequency getNotificationFrequency() {
        return this.behaviour.getNotificationFrequency();
    }

    private static final class ProxyPolicy {
        @NotNull
        private final Object proxy;
        @NotNull
        private final ProxyPolicyInvocationHandler handler;

        public ProxyPolicy(@NotNull Object proxy, @NotNull ProxyPolicyInvocationHandler handler) {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy is null");
            }
            this.proxy = proxy;
            this.handler = handler;
        }

        @NotNull
        public final Object getProxy() {
            return this.proxy;
        }

        @NotNull
        public final ProxyPolicyInvocationHandler getHandler() {
            return this.handler;
        }
    }

    private static final class ProxyPolicyInvocationHandler
    implements InvocationHandler {
        private Object target;
        private Behaviour behaviour;
        @NotNull
        private final Timer timer;

        public ProxyPolicyInvocationHandler(@Nullable Object target, @Nullable Behaviour behaviour, @NotNull Timer timer) {
            if (timer == null) {
                throw new IllegalArgumentException("timer is null");
            }
            this.target = target;
            this.behaviour = behaviour;
            this.timer = timer;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy is null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method is null");
            }
            if (method.getDeclaringClass().isAssignableFrom(Object.class)) {
                if (args != null) {
                    return method.invoke((Object)this, Arrays.copyOf(args, args.length));
                }
                return method.invoke((Object)this, new Object[0]);
            }
            if (Policy.class.isAssignableFrom(method.getDeclaringClass())) {
                if (this.behaviour != null) {
                    try {
                        return this.timer.time(() -> {
                            StringBuilder labelBuilder = new StringBuilder();
                            labelBuilder.append(this.behaviour.toString()).append(" ");
                            if (args != null) {
                                labelBuilder.append(Arrays.stream(args).filter(arg -> arg instanceof NodeRef).map(Object::toString).collect(Collectors.joining(",")));
                            }
                            return labelBuilder.toString();
                        }, () -> args != null ? method.invoke(this.target, Arrays.copyOf(args, args.length)) : method.invoke(this.target, new Object[0]));
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                return null;
            }
            throw new AssertionError((Object)("Cannot handle methods from " + method.getDeclaringClass()));
        }

        public final void release() {
            this.target = null;
            this.behaviour = null;
        }

        @NotNull
        public final Timer getTimer() {
            return this.timer;
        }
    }
}

