/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.policy;

import com.github.dynamicextensionsalfresco.metrics.Timer;
import com.github.dynamicextensionsalfresco.policy.BehaviourProxy;
import com.github.dynamicextensionsalfresco.policy.BehaviourProxyFactory;
import java.util.ArrayList;
import org.alfresco.repo.policy.Behaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class DefaultBehaviourProxyFactory
implements BehaviourProxyFactory,
ApplicationListener<ContextClosedEvent> {
    private Logger logger = LoggerFactory.getLogger(DefaultBehaviourProxyFactory.class);
    @Autowired
    protected Timer timer;
    private ArrayList<BehaviourProxy> behaviourProxies = new ArrayList();

    @Override
    public BehaviourProxy createBehaviourProxy(Behaviour behaviour) {
        this.logger.debug("Creating BehaviourProxy for {} instance.", (Object)behaviour.getClass().getName());
        BehaviourProxy behaviourProxy = new BehaviourProxy(behaviour, this.timer);
        this.behaviourProxies.add(behaviourProxy);
        return behaviourProxy;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.releaseBehaviourReferences();
    }

    protected void releaseBehaviourReferences() {
        for (BehaviourProxy behaviourProxy : this.behaviourProxies) {
            this.logger.debug("Releasing reference from BehaviourProxy to " + behaviourProxy.toString() + " instance.");
            behaviourProxy.release();
        }
        this.behaviourProxies.clear();
    }
}

