/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.policy;

import com.github.dynamicextensionsalfresco.policy.BehaviourProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.PolicyComponent;

class ProxyPolicyComponentInvocationHandler
implements InvocationHandler {
    private final PolicyComponent policyComponent;
    private final BehaviourProxyFactory behaviourProxyFactory;

    ProxyPolicyComponentInvocationHandler(PolicyComponent policyComponent, BehaviourProxyFactory behaviourProxyFactory) {
        this.policyComponent = policyComponent;
        this.behaviourProxyFactory = behaviourProxyFactory;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        if (this.isBehaviourBindingMethod(method)) {
            this.replaceBehaviourArgumentsWithProxies(args);
        }
        return method.invoke((Object)this.policyComponent, args);
    }

    private boolean isBehaviourBindingMethod(Method method) {
        return method.getName().matches("bind\\w+?Behaviour");
    }

    private void replaceBehaviourArgumentsWithProxies(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Behaviour)) continue;
            args[i] = this.behaviourProxyFactory.createBehaviourProxy((Behaviour)args[i]);
        }
    }
}

