/*
 * Decompiled with CFR 0.152.
 */
package com.github.dynamicextensionsalfresco.resources;

import com.github.dynamicextensionsalfresco.annotations.AlfrescoService;
import com.github.dynamicextensionsalfresco.annotations.ServiceType;
import com.github.dynamicextensionsalfresco.resources.BootstrapService;
import com.github.dynamicextensionsalfresco.resources.ResourceHelper;
import com.github.dynamicextensionsalfresco.resources.UpdateStrategy;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class DefaultBootstrapService
implements ResourceLoaderAware,
BootstrapService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBootstrapService.class);
    @Autowired
    protected ResourceHelper resourceHelper;
    @Autowired
    @AlfrescoService(value=ServiceType.LOW_LEVEL)
    protected ContentService contentService;
    @Autowired
    @AlfrescoService(value=ServiceType.LOW_LEVEL)
    protected NodeService nodeService;
    @Autowired
    @AlfrescoService(value=ServiceType.LOW_LEVEL)
    protected SearchService searchService;
    @Autowired
    @AlfrescoService(value=ServiceType.LOW_LEVEL)
    protected NamespaceService namespaceService;
    @Autowired
    protected FileFolderService fileFolderService;
    @Autowired
    protected MimetypeService mimetypeService;
    private ResourcePatternResolver resourcePatternResolver;

    @Override
    public Map<Resource, NodeRef> deployResources(String resourcePattern, RepositoryLocation targetLocation, UpdateStrategy updateStrategy, String encoding, String mimetype, QName nodeType) throws IOException {
        Resource[] resources;
        HashMap<Resource, NodeRef> nodeReferences = new HashMap<Resource, NodeRef>();
        for (Resource resource : resources = this.resourcePatternResolver.getResources(resourcePattern)) {
            NodeRef result = this.deployResource(targetLocation, updateStrategy, encoding, mimetype, resource, nodeType);
            nodeReferences.put(resource, result);
        }
        return nodeReferences;
    }

    @Override
    public NodeRef deployResource(RepositoryLocation targetLocation, UpdateStrategy updateStrategy, String encoding, String mimetype, Resource resource, QName nodeType) throws IOException {
        NodeRef existingNode = this.resourceHelper.findNodeForResource(resource, targetLocation);
        if (existingNode == null) {
            NodeRef nodeRef = this.createNode(resource, targetLocation, encoding, mimetype, nodeType);
            logger.debug("Deployed {} as new node {}.", (Object)resource, (Object)nodeRef);
            return nodeRef;
        }
        if (updateStrategy.updateNode(resource, existingNode)) {
            this.updateNode(resource, existingNode);
            logger.debug("Updated {} to existing node {}.", (Object)resource, (Object)existingNode);
        } else {
            logger.debug("No changes detected between resource {} and node {}.", (Object)resource, (Object)existingNode);
        }
        return existingNode;
    }

    @Override
    public void updateNode(Resource resource, NodeRef existingNode) throws IOException {
        this.contentService.getWriter(existingNode, ContentModel.PROP_CONTENT, true).putContent(resource.getInputStream());
    }

    @Override
    public NodeRef createNode(Resource resource, RepositoryLocation targetLocation, String encoding, String mimetype, QName nodeType) throws IOException {
        NodeRef rootNode = this.nodeService.getRootNode(targetLocation.getStoreRef());
        List parentNodes = this.searchService.selectNodes(rootNode, targetLocation.getPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
        Assert.isTrue((parentNodes.size() == 1 ? 1 : 0) != 0, (String)"Target location leads to not 1 unique Node reference");
        String fileName = resource.getFilename();
        FileInfo fileInfo = this.fileFolderService.create((NodeRef)parentNodes.get(0), fileName, nodeType);
        NodeRef nodeRef = fileInfo.getNodeRef();
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.putContent(resource.getInputStream());
        if (mimetype == null) {
            mimetype = this.guessMimetype(resource);
        }
        if (encoding == null) {
            encoding = this.guessEncoding(resource.getInputStream(), mimetype);
        }
        writer.setMimetype(mimetype);
        writer.setEncoding(encoding);
        return nodeRef;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = (ResourcePatternResolver)resourceLoader;
    }

    @Override
    public String guessMimetype(Resource resource) {
        return this.mimetypeService.guessMimetype(resource.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String guessEncoding(InputStream in, String mimetype) {
        String encoding = "UTF-8";
        try {
            if (in != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
                Charset charset = this.mimetypeService.getContentCharsetFinder().getCharset((InputStream)bufferedInputStream, mimetype);
                encoding = charset.name();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return encoding;
    }
}

